package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class SQLBigIntExpr extends SQLNumericLiteralExpr implements SQLValuableExpr {
   private Long value;

   public SQLBigIntExpr() {
   }

   public SQLBigIntExpr(Long value) {
      this.value = value;
   }

   public SQLBigIntExpr(String value) {
      this.value = Long.valueOf(value);
   }

   public SQLBigIntExpr clone() {
      return new SQLBigIntExpr(this.value);
   }

   public List<SQLObject> getChildren() {
      return Collections.emptyList();
   }

   public Number getNumber() {
      return this.value;
   }

   public Long getValue() {
      return this.value;
   }

   public void setValue(Long value) {
      this.value = value;
   }

   protected void accept0(SQLASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         SQLBigIntExpr other = (SQLBigIntExpr)obj;
         if (this.value == null) {
            if (other.value != null) {
               return false;
            }
         } else if (!this.value.equals(other.value)) {
            return false;
         }

         return true;
      }
   }

   public void setNumber(Number number) {
      if (number == null) {
         this.setValue((Long)null);
      } else {
         this.setValue((Long)number);
      }
   }
}
