package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.List;

public class SQLShowIndexesStatement extends SQLStatementImpl implements SQLShowStatement {
   private SQLExprTableSource table;
   private List<SQLCommentHint> hints;
   private SQLExpr where;
   private String type;
   private SQLExpr db;
   private SQLIdentifierExpr fromOrInDatabase;
   private boolean extended;

   public SQLExprTableSource getTable() {
      return this.table;
   }

   public void setTable(SQLName table) {
      this.setTable(new SQLExprTableSource(table));
   }

   public void setTable(SQLExprTableSource table) {
      this.table = table;
   }

   public SQLName getDatabase() {
      SQLExpr expr = this.table.getExpr();
      return expr instanceof SQLPropertyExpr ? (SQLName)((SQLPropertyExpr)expr).getOwner() : null;
   }

   public SQLExpr getWhere() {
      return this.where;
   }

   public void setWhere(SQLExpr where) {
      this.where = where;
   }

   public String getType() {
      return this.type;
   }

   public void setType(String type) {
      this.type = type;
   }

   public void setDatabase(String database) {
      this.table.setSchema(database);
   }

   public void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.table);
         this.acceptChild(visitor, this.where);
      }

      visitor.endVisit(this);
   }

   public List<SQLCommentHint> getHints() {
      return this.hints;
   }

   public void setHints(List<SQLCommentHint> hints) {
      this.hints = hints;
   }

   public SQLExpr getDb() {
      return this.db;
   }

   public void setDb(SQLExpr db) {
      this.db = db;
   }

   public boolean isExtended() {
      return this.extended;
   }

   public void setExtended(boolean extended) {
      this.extended = extended;
   }

   public void setFromOrInDatabase(SQLIdentifierExpr fromOrInDatabase) {
      this.fromOrInDatabase = fromOrInDatabase;
   }

   public SQLIdentifierExpr getFromOrInDatabase() {
      return this.fromOrInDatabase;
   }
}
