package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.FastsqlException;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.IOException;

public class SQLUpdateSetItem extends SQLObjectImpl implements SQLReplaceable {
   private SQLExpr column;
   private SQLExpr value;

   public SQLExpr getColumn() {
      return this.column;
   }

   public void cloneTo(SQLUpdateSetItem x) {
      if (this.column != null) {
         x.column = this.column.clone();
         x.column.setParent(x);
      }

      if (this.value != null) {
         x.value = this.value.clone();
         x.value.setParent(x);
      }

   }

   public SQLUpdateSetItem clone() {
      SQLUpdateSetItem x = new SQLUpdateSetItem();
      this.cloneTo(x);
      return x;
   }

   public void setColumn(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.column = x;
   }

   public SQLExpr getValue() {
      return this.value;
   }

   public void setValue(SQLExpr value) {
      if (value != null) {
         value.setParent(this);
      }

      this.value = value;
   }

   public void output(Appendable buf) {
      try {
         this.column.output(buf);
         buf.append(" = ");
         this.value.output(buf);
      } catch (IOException ex) {
         throw new FastsqlException("output error", ex);
      }
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         if (this.column != null) {
            this.column.accept(visitor);
         }

         if (this.value != null) {
            this.value.accept(visitor);
         }
      }

      visitor.endVisit(this);
   }

   public boolean columnMatch(String column) {
      if (this.column instanceof SQLIdentifierExpr) {
         return ((SQLIdentifierExpr)this.column).nameEquals(column);
      } else {
         if (this.column instanceof SQLPropertyExpr) {
            ((SQLPropertyExpr)this.column).nameEquals(column);
         }

         return false;
      }
   }

   public boolean columnMatch(long columnHash) {
      if (this.column instanceof SQLName) {
         return ((SQLName)this.column).nameHashCode64() == columnHash;
      } else {
         return false;
      }
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (expr == this.column) {
         this.setColumn(target);
         return true;
      } else if (expr == this.value) {
         this.setValue(target);
         return true;
      } else {
         return false;
      }
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         SQLUpdateSetItem that = (SQLUpdateSetItem)o;
         if (this.column != null) {
            if (!this.column.equals(that.column)) {
               return false;
            }
         } else if (that.column != null) {
            return false;
         }

         return this.value != null ? this.value.equals(that.value) : that.value == null;
      } else {
         return false;
      }
   }

   public int hashCode() {
      int result = this.column != null ? this.column.hashCode() : 0;
      result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
      return result;
   }
}
