package com.alibaba.druid.sql.builder.impl;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.builder.SQLDeleteBuilder;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleDeleteStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGDeleteStatement;
import java.util.List;

public class SQLDeleteBuilderImpl implements SQLDeleteBuilder {
   private SQLDeleteStatement stmt;
   private DbType dbType;

   public SQLDeleteBuilderImpl(DbType dbType) {
      this.dbType = dbType;
   }

   public SQLDeleteBuilderImpl(String sql, DbType dbType) {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() == 0) {
         throw new IllegalArgumentException("not support empty-statement :" + sql);
      } else if (stmtList.size() > 1) {
         throw new IllegalArgumentException("not support multi-statement :" + sql);
      } else {
         SQLDeleteStatement stmt = (SQLDeleteStatement)stmtList.get(0);
         this.stmt = stmt;
         this.dbType = dbType;
      }
   }

   public SQLDeleteBuilderImpl(SQLDeleteStatement stmt, DbType dbType) {
      this.stmt = stmt;
      this.dbType = dbType;
   }

   public SQLDeleteBuilderImpl limit(int rowCount) {
      throw new UnsupportedOperationException();
   }

   public SQLDeleteBuilderImpl limit(int rowCount, int offset) {
      throw new UnsupportedOperationException();
   }

   public SQLDeleteBuilder from(String table) {
      return this.from(table, (String)null);
   }

   public SQLDeleteBuilder from(String table, String alias) {
      SQLDeleteStatement delete = this.getSQLDeleteStatement();
      SQLExprTableSource from = new SQLExprTableSource(new SQLIdentifierExpr(table), alias);
      delete.setTableSource((SQLTableSource)from);
      return this;
   }

   public SQLDeleteBuilder where(String expr) {
      SQLDeleteStatement delete = this.getSQLDeleteStatement();
      SQLExpr exprObj = SQLUtils.toSQLExpr(expr, this.dbType);
      delete.setWhere(exprObj);
      return this;
   }

   public SQLDeleteBuilder whereAnd(String expr) {
      SQLDeleteStatement delete = this.getSQLDeleteStatement();
      SQLExpr exprObj = SQLUtils.toSQLExpr(expr, this.dbType);
      SQLExpr newCondition = SQLUtils.buildCondition(SQLBinaryOperator.BooleanAnd, exprObj, false, delete.getWhere());
      delete.setWhere(newCondition);
      return this;
   }

   public SQLDeleteBuilder whereOr(String expr) {
      SQLDeleteStatement delete = this.getSQLDeleteStatement();
      SQLExpr exprObj = SQLUtils.toSQLExpr(expr, this.dbType);
      SQLExpr newCondition = SQLUtils.buildCondition(SQLBinaryOperator.BooleanOr, exprObj, false, delete.getWhere());
      delete.setWhere(newCondition);
      return this;
   }

   public SQLDeleteStatement getSQLDeleteStatement() {
      if (this.stmt == null) {
         this.stmt = this.createSQLDeleteStatement();
      }

      return this.stmt;
   }

   public SQLDeleteStatement createSQLDeleteStatement() {
      switch (this.dbType) {
         case oracle:
            return new OracleDeleteStatement();
         case mysql:
            return new MySqlDeleteStatement();
         case postgresql:
            return new PGDeleteStatement();
         default:
            return new SQLDeleteStatement();
      }
   }

   public String toString() {
      return SQLUtils.toSQLString(this.stmt, (DbType)this.dbType);
   }
}
