package com.alibaba.druid.sql.dialect.db2.ast.expr;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import java.util.Collections;
import java.util.List;

public class DB2ExtractExpr extends DB2ExprImpl implements SQLReplaceable {
   private DB2DateField field;
   private SQLExpr source;

   public DB2ExtractExpr clone() {
      DB2ExtractExpr x = new DB2ExtractExpr();
      x.field = this.field;
      if (this.source != null) {
         x.setSource(this.source.clone());
      }

      return x;
   }

   public DB2DateField getField() {
      return this.field;
   }

   public void setField(DB2DateField field) {
      this.field = field;
   }

   public SQLExpr getSource() {
      return this.source;
   }

   public void setSource(SQLExpr source) {
      if (source != null) {
         source.setParent(this);
      }

      this.source = source;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.source == expr) {
         this.setSource(target);
         return true;
      } else {
         return false;
      }
   }

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.source);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      return Collections.singletonList(this.source);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
      result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         DB2ExtractExpr other = (DB2ExtractExpr)obj;
         if (this.field != other.field) {
            return false;
         } else {
            if (this.source == null) {
               if (other.source != null) {
                  return false;
               }
            } else if (!this.source.equals(other.source)) {
               return false;
            }

            return true;
         }
      }
   }
}
