package com.alibaba.druid.sql.dialect.db2.ast.expr.tablesource;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.dialect.db2.ast.DB2SQLObject;
import com.alibaba.druid.sql.dialect.db2.ast.expr.DB2ExprImpl;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class DB2ValuesTableSource extends SQLExprTableSource implements DB2SQLObject, DB2TableSource {
   private List<ValueRow> rows = new ArrayList();

   public List<ValueRow> getRows() {
      return this.rows;
   }

   public void setRows(List<ValueRow> rows) {
      this.rows = rows;
   }

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this) && this.rows != null) {
         for(ValueRow row : this.rows) {
            row.accept(visitor);
         }
      }

      visitor.endVisit(this);
   }

   public void addColumnAlias(SQLName name) {
      if (this.columns == null) {
         this.columns = new ArrayList();
      }

      this.columns.add(name);
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((DB2ASTVisitor)visitor);
   }

   public boolean isOnly() {
      return this.only;
   }

   public void setOnly(boolean only) {
      this.only = only;
   }

   public DB2ValuesTableSource clone() {
      DB2ValuesTableSource x = new DB2ValuesTableSource();
      this.cloneTo(x);

      for(ValueRow row : this.rows) {
         if (row != null) {
            x.rows.add(row.clone());
         } else {
            x.rows.add(null);
         }
      }

      return x;
   }

   public boolean equals(Object o) {
      if (o == null) {
         return false;
      } else if (o.getClass() != this.getClass()) {
         return false;
      } else {
         DB2ValuesTableSource row = (DB2ValuesTableSource)o;
         if (row.rows == this.rows) {
            return true;
         } else if (row.rows.size() == this.rows.size()) {
            return false;
         } else {
            for(int i = 0; i < this.rows.size(); ++i) {
               if (!((ValueRow)row.rows.get(i)).equals(this.rows.get(i))) {
                  return false;
               }
            }

            return true;
         }
      }
   }

   public int hashCode() {
      int prime = 31;
      int result = this.rows.hashCode();

      for(SQLExpr val : this.rows) {
         result = 31 * result + val.hashCode();
      }

      return result;
   }

   public static class ValueRow extends DB2ExprImpl {
      private List<SQLExpr> vals = new ArrayList();

      public List<SQLExpr> getVals() {
         return this.vals;
      }

      public void setVals(List<SQLExpr> vals) {
         this.vals = vals;
      }

      public boolean equals(Object o) {
         if (o == null) {
            return false;
         } else if (o.getClass() != this.getClass()) {
            return false;
         } else {
            ValueRow row = (ValueRow)o;
            if (row.vals == this.vals) {
               return true;
            } else if (row.vals.size() == this.vals.size()) {
               return false;
            } else {
               for(int i = 0; i < this.vals.size(); ++i) {
                  if (!((SQLExpr)row.vals.get(i)).equals(this.vals.get(i))) {
                     return false;
                  }
               }

               return true;
            }
         }
      }

      public int hashCode() {
         int prime = 31;
         int result = this.vals.hashCode();

         for(SQLExpr val : this.vals) {
            result = 31 * result + val.hashCode();
         }

         return result;
      }

      public ValueRow clone() {
         ValueRow row = new ValueRow();

         for(SQLExpr val : this.vals) {
            if (val == null) {
               row.vals.add(null);
            } else {
               row.vals.add(val.clone());
            }
         }

         return row;
      }

      public void accept0(DB2ASTVisitor visitor) {
         if (visitor.visit(this) && this.vals != null && this.vals.size() > 0) {
            for(SQLExpr val : this.vals) {
               val.accept(visitor);
            }
         }

         visitor.endVisit(this);
      }
   }
}
