package com.alibaba.druid.sql.dialect.es.ast;

import com.alibaba.druid.sql.dialect.es.visitor.EsField;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class EsParserBase extends Parser {
   public int version = 716;
   public int apiType = 0;
   public int type = 0;
   public Map<String, EsField> fields = new HashMap();
   public List<ParseTree> regexTrees = new ArrayList();

   public EsParserBase(TokenStream input) {
      super(input);
   }

   public void addRegexTree(EsParserContextBase regex) {
      this.regexTrees.add(regex);
      regex.supportRegex = true;
   }

   public void setField(String name, ParseTree ref) {
      EsField field = (EsField)this.fields.get(name);
      if (field == null) {
         field = new EsField();
         field.name = name;
         field.refs.add(ref);
         this.fields.put(name, field);
      }

   }

   public void setField(ParseTree nameTree) {
      this.setField(nameTree.getText(), nameTree);
   }

   public void setField(ParseTree nameTree, ParseTree valueTree) {
      String name = nameTree.getText();
      String value = valueTree.getText();
      EsField field = (EsField)this.fields.get(name);
      if (field == null) {
         field = new EsField();
         field.name = name;
         field.refs.add(nameTree);
         this.fields.put(name, field);
      }

      EsField.FieldValue fieldValue = (EsField.FieldValue)field.values.get(value);
      if (fieldValue == null) {
         fieldValue = new EsField.FieldValue();
         field.values.put(value, fieldValue);
      }

      fieldValue.refs.add(valueTree);
   }

   public void setFieldValue(String name, String value, ParseTree ref) {
      EsField field = (EsField)this.fields.get(name);
      if (field == null) {
         field = new EsField();
         field.name = name;
         field.refs.add(ref);
         this.fields.put(name, field);
      }

      EsField.FieldValue fieldValue = (EsField.FieldValue)field.values.get(value);
      if (fieldValue == null) {
         fieldValue = new EsField.FieldValue();
         field.values.put(value, fieldValue);
      }

      fieldValue.refs.add(ref);
   }
}
