package com.alibaba.druid.sql.dialect.gauss.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.statement.SQLConstraint;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.dialect.gauss.ast.GaussSQLPartition;
import com.alibaba.druid.sql.dialect.gauss.ast.GaussSQLPartitionBy;
import com.alibaba.druid.sql.dialect.gauss.ast.expr.GaussOptionValue;
import com.alibaba.druid.sql.dialect.gauss.ast.expr.constraint.GaussConstraint;
import com.alibaba.druid.sql.dialect.gauss.ast.expr.constraint.GaussStorageParameter;
import com.alibaba.druid.sql.dialect.gauss.ast.expr.tablesource.GaussExprTableSource;
import com.alibaba.druid.sql.dialect.gauss.ast.stmt.GaussCreateTableStatement;
import com.alibaba.druid.sql.dialect.gauss.ast.stmt.alterTable.GaussColumnDefinition;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class GaussCreateTableParser extends SQLCreateTableParser {
   public GaussCreateTableParser(Lexer lexer) {
      super((SQLExprParser)(new GaussExprParser(lexer)));
   }

   public GaussCreateTableParser(String sql) {
      super((SQLExprParser)(new GaussExprParser(sql)));
   }

   public GaussCreateTableParser(SQLExprParser exprParser) {
      super(exprParser);
   }

   public GaussSQLPartitionBy parsePartitionBy2() {
      this.lexer.nextToken();
      this.accept(Token.BY);
      GaussSQLPartitionBy partitionBy1 = new GaussSQLPartitionBy();
      partitionBy1.setPartitionType(this.exprParser.name());
      this.accept(Token.LPAREN);
      partitionBy1.setColumn(this.exprParser.name());
      this.accept(Token.RPAREN);
      boolean useTemplate = false;
      boolean hasSubpartition = false;

      while(this.lexer.identifierEquals("SUBPARTITION")) {
         hasSubpartition = true;
         this.lexer.nextToken();
         this.accept(Token.BY);
         GaussSQLPartitionBy subPartitionBy = new GaussSQLPartitionBy();
         subPartitionBy.setIfSubPartitionBy(true);
         subPartitionBy.setPartitionType(this.exprParser.name());
         this.accept(Token.LPAREN);
         subPartitionBy.setColumn(this.exprParser.name());
         this.accept(Token.RPAREN);
         partitionBy1.getSubPartitionByList().add(subPartitionBy);
         if (this.lexer.identifierEquals("SUBPARTITION")) {
            Lexer.SavePoint mark = this.lexer.mark();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.BY) {
               this.lexer.reset(mark);
               continue;
            }

            if (this.lexer.identifierEquals("TEMPLATE")) {
               useTemplate = true;
               subPartitionBy.setIfUseTemplate(true);
               this.lexer.nextToken();
               this.accept(Token.LPAREN);
               subPartitionBy.setPartitionList(this.parsePartitionSpec());
               this.accept(Token.RPAREN);
               continue;
            }
         }

         if (!this.lexer.identifierEquals("SUBPARTITION")) {
            break;
         }
      }

      if (!useTemplate && hasSubpartition) {
         int level = 0;

         do {
            if (this.lexer.token() == Token.LPAREN) {
               ++level;
               this.lexer.nextToken();
            }

            ArrayList<GaussSQLPartition> partition = this.parsePartitionSpec();
            if (level == 1) {
               partitionBy1.getPartitionList().addAll(partition);
            } else {
               ((GaussSQLPartitionBy)partitionBy1.getSubPartitionByList().get(level - 2)).getPartitionList().addAll(partition);
            }

            while(this.lexer.token() == Token.RPAREN) {
               --level;
               this.lexer.nextToken();
            }

            if (this.lexer.token() == Token.COMMA) {
               this.lexer.nextToken();
            }
         } while(level != 0);

         for(GaussSQLPartitionBy partitionBy : partitionBy1.getSubPartitionByList()) {
            HashSet<String> strings = new HashSet();
            ArrayList<GaussSQLPartition> partitionList = partitionBy.getPartitionList();
            Iterator<GaussSQLPartition> iterator = partitionList.iterator();

            while(iterator.hasNext()) {
               GaussSQLPartition next = (GaussSQLPartition)iterator.next();
               String s = next.getName().toString();
               if (strings.contains(s)) {
                  iterator.remove();
               } else {
                  strings.add(s);
               }
            }
         }
      } else if (this.lexer.token() == Token.LPAREN) {
         this.lexer.nextToken();
         ArrayList<GaussSQLPartition> specList = this.parsePartitionSpec();

         for(GaussSQLPartition spec : specList) {
            spec.setSubPartition(false);
         }

         this.lexer.nextToken();
         partitionBy1.setPartitionList(specList);
      }

      return partitionBy1;
   }

   public GaussCreateTableStatement parseCreateTable() {
      List<String> comments = null;
      if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
         comments = this.lexer.readAndResetComments();
      }

      GaussCreateTableStatement stmt = this.parseCreateTable(true);
      if (comments != null) {
         stmt.addBeforeComment(comments);
      }

      return stmt;
   }

   public GaussCreateTableStatement parseCreateTable(boolean acceptCreate) {
      GaussCreateTableStatement createTable = new GaussCreateTableStatement();
      createTable.setDbType(DbType.gauss);
      if (acceptCreate) {
         if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            createTable.addBeforeComment(this.lexer.readAndResetComments());
         }

         this.accept(Token.CREATE);
      }

      boolean isGlobal = false;
      boolean isLocal = false;
      if (this.lexer.token() != Token.GLOBAL && !this.lexer.identifierEquals("GLOBAL")) {
         if (this.lexer.token() == Token.LOCAL || this.lexer.identifierEquals("LOCAL")) {
            this.lexer.nextToken();
            isLocal = true;
         }
      } else {
         this.lexer.nextToken();
         isGlobal = true;
      }

      if (this.lexer.token() != Token.TEMPORARY && !this.lexer.identifierEquals("TEMPORARY")) {
         if (this.lexer.token() == Token.TEMP || this.lexer.identifierEquals("TEMP")) {
            this.lexer.nextToken();
            if (isGlobal) {
               createTable.setTableType(GaussCreateTableStatement.TableType.GLOBAL_TEMP);
            } else if (isLocal) {
               createTable.setTableType(GaussCreateTableStatement.TableType.LOCAL_TEMP);
            } else {
               createTable.setTableType(GaussCreateTableStatement.TableType.TEMP);
            }
         }
      } else {
         this.lexer.nextToken();
         if (isGlobal) {
            createTable.setTableType(GaussCreateTableStatement.TableType.GLOBAL_TEMPORARY);
         } else if (isLocal) {
            createTable.setTableType(GaussCreateTableStatement.TableType.LOCAL_TEMPORARY);
         } else {
            createTable.setTableType(GaussCreateTableStatement.TableType.TEMPORARY);
         }
      }

      if (this.lexer.token() == Token.UNLOGGED || this.lexer.identifierEquals("UNLOGGED")) {
         this.lexer.nextToken();
         if (isGlobal) {
            createTable.setTableType(GaussCreateTableStatement.TableType.GLOBAL_UNLOGGED);
         } else if (isLocal) {
            createTable.setTableType(GaussCreateTableStatement.TableType.LOCAL_UNLOGGED);
         } else {
            createTable.setTableType(GaussCreateTableStatement.TableType.UNLOGGED);
         }
      }

      this.accept(Token.TABLE);
      if (this.lexer.token() == Token.IF || this.lexer.identifierEquals("IF")) {
         this.lexer.nextToken();
         this.accept(Token.NOT);
         this.accept(Token.EXISTS);
         createTable.setIfNotExiists(true);
      }

      GaussExprTableSource tableSource = new GaussExprTableSource();
      SQLName name = this.exprParser.name();
      tableSource.setExpr(name);
      createTable.setTableSource(tableSource);
      createTable.setName(name);
      if (this.lexer.token() == Token.OF) {
         this.lexer.nextToken();
         createTable.setOfType(this.exprParser.name());
      }

      if (this.lexer.token() == Token.LPAREN) {
         this.lexer.nextToken();

         do {
            if (this.lexer.token() == Token.CONSTRAINT) {
               SQLConstraint constraint = this.exprParser.parseConstaint();
               constraint.setParent(createTable);
               createTable.getTableElementList().add((SQLTableElement)constraint);
            } else {
               GaussColumnDefinition gaussColumnDefinition = this.parseColumnDefinition();
               gaussColumnDefinition.setParent(createTable);
               createTable.getTableElementList().add(gaussColumnDefinition);
            }

            if (this.lexer.token() != Token.COMMA) {
               break;
            }

            this.lexer.nextToken();
         } while(this.lexer.token() != Token.RPAREN);

         this.accept(Token.RPAREN);
         if (this.lexer.identifierEquals(FnvHash.Constants.INHERITS)) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);

            while(this.lexer.token() != Token.RPAREN) {
               SQLName inherits = this.exprParser.name();
               createTable.addParentTable(inherits);
               if (this.lexer.token() == Token.COMMA) {
                  this.lexer.nextToken();
               }
            }

            this.accept(Token.RPAREN);
            this.lexer.nextToken();
         }
      }

      if (this.lexer.token() == Token.WITH) {
         this.lexer.nextToken();
         this.accept(Token.LPAREN);
         this.parseAssignItems(createTable.getTableOptions(), createTable, false);
         this.accept(Token.RPAREN);
      }

      if (this.lexer.token() == Token.ON) {
         this.lexer.nextToken();
         if (this.lexer.token() == Token.COMMIT || this.lexer.identifierEquals("COMMIT")) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.DELETE) {
               this.lexer.nextToken();
               this.lexer.nextToken();
               createTable.setOnCommit(GaussCreateTableStatement.OnCommit.deleteRows);
            } else if (this.lexer.token() == Token.DROP) {
               this.lexer.nextToken();
               createTable.setOnCommit(GaussCreateTableStatement.OnCommit.drop);
            } else if (this.lexer.identifierEquals("PRESERVE")) {
               this.lexer.nextToken();
               this.lexer.nextToken();
               createTable.setOnCommit(GaussCreateTableStatement.OnCommit.preserveRows);
            }
         }
      }

      if (this.lexer.token() == Token.TABLESPACE) {
         this.lexer.nextToken();
         createTable.setTablespace(this.exprParser.name());
      }

      if (this.lexer.token() == Token.AS) {
         createTable.setAs(true);
         this.lexer.nextToken();
         SQLSelectParser sqlSelectParser = this.createSQLSelectParser();
         SQLSelect select = sqlSelectParser.select();
         createTable.setSelect(select);
         if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("NO")) {
               this.lexer.nextToken();
               createTable.setWithNoData(true);
            } else {
               createTable.setWithNoData(false);
            }

            if (this.lexer.identifierEquals("DATA")) {
               if (!createTable.getWithNoData()) {
                  createTable.setWithData(true);
               }

               this.lexer.nextToken();
            }
         }
      }

      if (this.lexer.identifierEquals("DISTRIBUTED")) {
         this.lexer.nextToken();
         createTable.setDistributedBy(this.parseDistributedBy());
      }

      if (this.lexer.token() == Token.PARTITION) {
         GaussSQLPartitionBy partitionBy = this.parsePartitionBy2();
         createTable.setPartitioning(partitionBy);
      }

      return createTable;
   }

   private GaussColumnDefinition parseColumnDefinition() {
      String TABLE_CONSTRAINT_FLAG = "table-constraint";
      GaussColumnDefinition definition = new GaussColumnDefinition();
      definition.setName(this.exprParser.name());
      if (this.lexer.token() != Token.WITH && !this.lexer.identifierEquals("WITH")) {
         SQLDataType sqlDataType = this.exprParser.parseDataType();
         definition.setDataType(sqlDataType);
         if (this.lexer.identifierEquals("COLLATE")) {
            this.lexer.nextToken();
            definition.setCollateExpr(this.exprParser.expr());
         }
      } else {
         this.lexer.nextToken();
         this.lexer.nextToken();
         definition.setWith(true);
      }

      GaussConstraint constraint = null;

      do {
         constraint = this.parseColConstraint();
         if (constraint != null) {
            Object attribute = constraint.getAttribute("table-constraint");
            if (attribute != null && (Boolean)attribute) {
               definition.setTableConstraint(constraint);
               break;
            }

            definition.addConstraint(constraint);
         }
      } while(constraint != null);

      if (this.lexer.identifierEquals("ENCODING")) {
         this.lexer.nextToken();
         this.accept(Token.LPAREN);
         SQLExpr encoding = null;

         do {
            SQLExpr tbConstraint = this.parseOpionValue(true);
            if (tbConstraint != null) {
               definition.addEncoding(tbConstraint);
            }

            if (this.lexer.token() == Token.COMMA) {
               this.lexer.nextToken();
            }
         } while(this.lexer.token() != Token.RPAREN);

         this.lexer.nextToken();
      }

      GaussConstraint tbConstraint = this.parseColConstraint();
      if (tbConstraint != null) {
         definition.setTableConstraint(tbConstraint);
      }

      if (this.lexer.token() == Token.LIKE || this.lexer.identifierEquals("LIKE")) {
         this.lexer.nextToken();
         GaussExprTableSource ts = new GaussExprTableSource();
         ts.setExpr(this.exprParser.expr());
         definition.setLike(ts);
         GaussColumnDefinition.ColumnLikeOption option = null;

         do {
            option = this.parseLikeOption();
            if (option != null) {
               definition.addOption(option);
            }
         } while(option != null);
      }

      GaussConstraint.GaussReference reference = null;

      do {
         reference = this.parseReference();
         if (reference != null) {
            definition.addColumnReferenceStorageDirective(reference);
         }
      } while(reference != null);

      return definition;
   }

   private GaussConstraint parseColConstraint() {
      String TABLE_CONSTRAINT_FLAG = "table-constraint";
      boolean flag = false;
      GaussConstraint c = new GaussConstraint();
      if (this.lexer.token() == Token.CONSTRAINT) {
         this.lexer.nextToken();
         c.setName(this.exprParser.name());
         flag = true;
      }

      if (this.lexer.token() != Token.NOT && !this.lexer.identifierEquals("NOT")) {
         if (this.lexer.token() != Token.NULL && !this.lexer.identifierEquals("NULL")) {
            if (this.lexer.token() == Token.CHECK) {
               this.lexer.nextToken();
               this.accept(Token.LPAREN);
               GaussConstraint.GaussConstraintCheck check = new GaussConstraint.GaussConstraintCheck();
               check.setExpr(this.exprParser.expr());
               c.setCheck(check);
               this.accept(Token.RPAREN);
               if (this.lexer.identifierEquals("NO")) {
                  check.setNoInherit(true);
                  this.lexer.nextToken();
                  this.lexer.nextToken();
               }

               flag = true;
            } else if (this.lexer.token() != Token.DEFAULT && !this.lexer.identifierEquals("DEFAULT")) {
               if (this.lexer.token() != Token.UNIQUE && !this.lexer.identifierEquals("UNIQUE")) {
                  if (this.lexer.token() != Token.PRIMARY && !this.lexer.identifierEquals("PRIMARY")) {
                     if (this.lexer.token() != Token.FOREIGN && !this.lexer.identifierEquals("FOREIGN")) {
                        if (this.lexer.token() == Token.REFERENCES || this.lexer.identifierEquals("REFERENCES")) {
                           GaussConstraint.GaussReference ref = this.parseReference();
                           c.setReference(ref);
                           flag = true;
                        }
                     } else {
                        this.lexer.nextToken();
                        c.putAttribute("table-constraint", true);
                        this.accept(Token.KEY);
                        this.accept(Token.LPAREN);
                        GaussConstraint.GaussForeignKey foreign = new GaussConstraint.GaussForeignKey();

                        do {
                           foreign.addColumn(this.exprParser.name());
                           if (this.lexer.token() == Token.COMMA) {
                              this.lexer.nextToken();
                           }
                        } while(this.lexer.token() != Token.RPAREN);

                        this.lexer.nextToken();
                        foreign.setReference(this.parseReference());
                        flag = true;
                     }
                  } else {
                     this.lexer.nextToken();
                     this.accept(Token.KEY);
                     GaussConstraint.GaussPrimaryKey primaryKey = new GaussConstraint.GaussPrimaryKey();
                     if (this.lexer.token() == Token.LPAREN) {
                        c.putAttribute("table-constraint", true);
                        this.lexer.nextToken();

                        do {
                           primaryKey.addColumn(this.exprParser.name());
                           if (this.lexer.token() == Token.COMMA) {
                              this.lexer.nextToken();
                           }
                        } while(this.lexer.token() != Token.RPAREN);

                        this.lexer.nextToken();
                     }

                     primaryKey.setIndexParamaters(this.parseIndexParamaters());
                     c.setPrimaryKey(primaryKey);
                     flag = true;
                  }
               } else {
                  this.lexer.nextToken();
                  GaussConstraint.GaussUnique unique = new GaussConstraint.GaussUnique();
                  if (this.lexer.token() == Token.LPAREN) {
                     c.putAttribute("table-constraint", true);
                     this.lexer.nextToken();

                     do {
                        unique.addColumn(this.exprParser.name());
                        if (this.lexer.token() == Token.COMMA) {
                           this.lexer.nextToken();
                        }
                     } while(this.lexer.token() != Token.RPAREN);

                     this.lexer.nextToken();
                  }

                  unique.setIndexParamaters(this.parseIndexParamaters());
                  c.setUnique(unique);
                  flag = true;
               }
            } else {
               this.lexer.nextToken();
               c.setDefValue(this.exprParser.expr());
               c.putAttribute("table-constraint", true);
               flag = true;
            }
         } else {
            this.lexer.nextToken();
            c.setiNull(true);
            c.putAttribute("table-constraint", true);
            flag = true;
         }
      } else {
         Lexer.SavePoint mark = this.lexer.mark();
         this.lexer.nextToken();
         if (this.lexer.token() != Token.NULL && !this.lexer.identifierEquals("NULL")) {
            this.lexer.reset(mark);
         } else {
            c.setNotNull(true);
            this.lexer.nextToken();
            flag = true;
         }
      }

      GaussConstraint.ConstraintType constraintType = this.parseConstraintType();
      if (constraintType != null) {
         c.setType(constraintType);
         flag = true;
      }

      return !flag ? null : c;
   }

   private GaussConstraint.GaussIndexParamaters parseIndexParamaters() {
      GaussConstraint.GaussIndexParamaters ps = new GaussConstraint.GaussIndexParamaters();
      if (this.lexer.token() == Token.WITH || this.lexer.identifierEquals("WITH")) {
         this.lexer.nextToken();
         this.accept(Token.LPAREN);

         do {
            GaussStorageParameter parameter = new GaussStorageParameter();
            parameter.setOption(this.exprParser.expr());
            if (this.lexer.token() != Token.COMMA && this.lexer.token() != Token.RPAREN) {
               parameter.setValue(this.exprParser.expr());
            }

            ps.addParameter(parameter);
            if (this.lexer.token() == Token.COMMA) {
               this.lexer.nextToken();
            }
         } while(this.lexer.token() != Token.RPAREN);

         this.lexer.nextToken();
      }

      if (this.lexer.token() == Token.USING || this.lexer.identifierEquals("USING")) {
         this.lexer.nextToken();
         this.accept(Token.INDEX);
         this.accept(Token.TABLESPACE);
         ps.setTablespace(this.exprParser.expr());
      }

      return ps;
   }

   private GaussConstraint.GaussReference parseReference() {
      if (this.lexer.token() != Token.REFERENCES && !this.lexer.identifierEquals("REFERENCES")) {
         return null;
      } else {
         this.lexer.nextToken();
         GaussConstraint.GaussReference ref = new GaussConstraint.GaussReference();
         ref.setRefTable(this.exprParser.expr());
         if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();

            do {
               ref.addColumn(this.exprParser.name());
               if (this.lexer.token() == Token.COMMA) {
                  this.lexer.nextToken();
               }
            } while(this.lexer.token() != Token.RPAREN);

            this.lexer.nextToken();
         }

         if (this.lexer.identifierEquals("MATCH")) {
            this.lexer.nextToken();
            if (this.lexer.token() != Token.FULL && !this.lexer.identifierEquals("FULL")) {
               if (this.lexer.identifierEquals("PARTIAL")) {
                  this.lexer.nextToken();
                  ref.setMatchType(GaussConstraint.GaussReference.MatchType.partial);
               } else if (this.lexer.identifierEquals("SIMPLE")) {
                  this.lexer.nextToken();
                  ref.setMatchType(GaussConstraint.GaussReference.MatchType.simple);
               }
            } else {
               this.lexer.nextToken();
               ref.setMatchType(GaussConstraint.GaussReference.MatchType.full);
            }
         }

         if (this.lexer.token() == Token.ON || this.lexer.identifierEquals("ON")) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.DELETE) {
               this.lexer.nextToken();
               ref.setDeleteAction(this.parseKeyAction());
            } else if (this.lexer.token() == Token.UPDATE) {
               this.lexer.nextToken();
               ref.setUpdateAction(this.parseKeyAction());
            }
         }

         return ref;
      }
   }

   private GaussConstraint.GaussReference.KeyAction parseKeyAction() {
      if (this.lexer.token() == Token.ON) {
         this.lexer.nextToken();
         if (this.lexer.token() == Token.DELETE) {
            this.lexer.nextToken();
            return GaussConstraint.GaussReference.KeyAction.onDelete;
         }

         if (this.lexer.token() == Token.UPDATE) {
            this.lexer.nextToken();
            return GaussConstraint.GaussReference.KeyAction.onUpdate;
         }
      } else {
         if (this.lexer.identifierEquals("NO")) {
            this.lexer.nextToken();
            this.lexer.nextToken();
            return GaussConstraint.GaussReference.KeyAction.noAction;
         }

         if (this.lexer.token() == Token.RESTRICT || this.lexer.identifierEquals("RESTRICT")) {
            this.lexer.nextToken();
            return GaussConstraint.GaussReference.KeyAction.restrict;
         }

         if (this.lexer.token() == Token.CASCADE || this.lexer.identifierEquals("CASCADE")) {
            this.lexer.nextToken();
            return GaussConstraint.GaussReference.KeyAction.cascade;
         }

         if (this.lexer.token() == Token.SET || this.lexer.identifierEquals("SET")) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.DEFAULT || this.lexer.identifierEquals("DEFAULT")) {
               this.lexer.nextToken();
               return GaussConstraint.GaussReference.KeyAction.setDefault;
            }

            if (this.lexer.token() == Token.NULL || this.lexer.identifierEquals("NULL")) {
               this.lexer.nextToken();
               return GaussConstraint.GaussReference.KeyAction.setNull;
            }
         }
      }

      return null;
   }

   private GaussConstraint.ConstraintType parseConstraintType() {
      if (this.lexer.identifierEquals("DEFERRABLE")) {
         this.lexer.nextToken();
         return GaussConstraint.ConstraintType.deferrable;
      } else if (this.lexer.token() != Token.NOT && !this.lexer.identifierEquals("NOT")) {
         if (this.lexer.token() == Token.INITIALLY || this.lexer.identifierEquals("INITIALLY")) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.DEFERRED || this.lexer.identifierEquals("DEFERRED")) {
               this.lexer.nextToken();
               return GaussConstraint.ConstraintType.initiallyDeferred;
            }

            if (this.lexer.token() == Token.IMMEDIATE || this.lexer.identifierEquals("IMMEDIATE")) {
               this.lexer.nextToken();
               return GaussConstraint.ConstraintType.initiallyImmediate;
            }
         }

         return null;
      } else {
         this.lexer.nextToken();
         this.lexer.nextToken();
         return GaussConstraint.ConstraintType.notDeferrable;
      }
   }

   private GaussOptionValue parseOpionValue(boolean eq) {
      if (this.lexer.token() == Token.RPAREN) {
         return null;
      } else {
         Lexer.SavePoint mark = this.lexer.mark();
         GaussOptionValue e = new GaussOptionValue();
         SQLExpr expr = this.exprParser.expr();
         if (eq) {
            if (expr instanceof SQLBinaryOpExpr) {
               SQLBinaryOpExpr bin = (SQLBinaryOpExpr)expr;
               e.setOption(bin.getLeft());
               e.setValue(bin.getRight());
               return e;
            } else if (this.lexer.token() == Token.EQ) {
               e.setOption(expr);
               this.lexer.nextToken();
               e.setValue(this.exprParser.expr());
               return e;
            } else {
               this.lexer.reset(mark);
               return null;
            }
         } else {
            e.setOption(expr);
            if (this.lexer.token() != Token.COMMA && this.lexer.token() != Token.RPAREN) {
               e.setValue(this.exprParser.expr());
            }

            return e;
         }
      }
   }

   private GaussColumnDefinition.ColumnLikeOption parseLikeOption() {
      GaussColumnDefinition.ColumnLikeOption o = new GaussColumnDefinition.ColumnLikeOption();
      boolean flag = false;
      if (this.lexer.identifierEquals("INCLUDING")) {
         this.lexer.nextToken();
         flag = true;
         o.setIncludeType(GaussColumnDefinition.ColumnLikeOption.IncludeType.including);
      } else if (this.lexer.identifierEquals("EXCLUDING")) {
         this.lexer.nextToken();
         flag = true;
         o.setIncludeType(GaussColumnDefinition.ColumnLikeOption.IncludeType.excluding);
      }

      if (!flag) {
         return null;
      } else {
         if (this.lexer.identifierEquals("DEFAULTS")) {
            o.setOption(GaussColumnDefinition.ColumnLikeOption.OptionType.defaults);
            this.lexer.nextToken();
         } else if (this.lexer.identifierEquals("CONSTRAINTS")) {
            o.setOption(GaussColumnDefinition.ColumnLikeOption.OptionType.constraints);
            this.lexer.nextToken();
         } else if (this.lexer.identifierEquals("INDEXES")) {
            o.setOption(GaussColumnDefinition.ColumnLikeOption.OptionType.indexes);
            this.lexer.nextToken();
         } else if (this.lexer.token() != Token.STORAGE && !this.lexer.identifierEquals("STORAGE")) {
            if (this.lexer.identifierEquals("COMMENTS")) {
               o.setOption(GaussColumnDefinition.ColumnLikeOption.OptionType.comments);
               this.lexer.nextToken();
            } else if (this.lexer.token() == Token.ALL || this.lexer.identifierEquals("ALL")) {
               o.setOption(GaussColumnDefinition.ColumnLikeOption.OptionType.all);
               this.lexer.nextToken();
            }
         } else {
            o.setOption(GaussColumnDefinition.ColumnLikeOption.OptionType.storage);
            this.lexer.nextToken();
         }

         return o;
      }
   }

   private GaussCreateTableStatement.GaussTableDistributedBy parseDistributedBy() {
      GaussCreateTableStatement.GaussTableDistributedBy by = new GaussCreateTableStatement.GaussTableDistributedBy();
      if (this.lexer.token() == Token.BY) {
         this.lexer.nextToken();
         this.accept(Token.LPAREN);
         GaussOptionValue value = null;

         do {
            value = this.parseOpionValue(false);
            if (value != null) {
               by.addColum(value);
            }

            if (this.lexer.token() == Token.COMMA) {
               this.lexer.nextToken();
            }
         } while(value != null);

         this.lexer.nextToken();
         by.setOption(GaussCreateTableStatement.GaussTableDistributedBy.Option.by);
      } else if (this.lexer.identifierEquals("RANDOMLY")) {
         this.lexer.nextToken();
         by.setOption(GaussCreateTableStatement.GaussTableDistributedBy.Option.randomly);
      } else if (this.lexer.identifierEquals("REPLICATED")) {
         this.lexer.nextToken();
         by.setOption(GaussCreateTableStatement.GaussTableDistributedBy.Option.replicated);
      }

      return by;
   }

   private ArrayList<GaussSQLPartition> parsePartitionSpec() {
      ArrayList<GaussSQLPartition> specList = new ArrayList();
      SQLName defaultName = null;

      while(true) {
         if (this.lexer.token() == Token.DEFAULT) {
            this.accept(Token.DEFAULT);
            this.lexer.nextToken();
            defaultName = this.exprParser.name();
         } else {
            GaussSQLPartition partition = new GaussSQLPartition();
            specList.add(partition);
            if (this.lexer.token() == Token.PARTITION) {
               partition.setSubPartition(false);
               this.lexer.nextToken();
               partition.setName(this.exprParser.name());
            } else if (this.lexer.identifierEquals("SUBPARTITION")) {
               partition.setSubPartition(true);
               this.lexer.nextToken();
               partition.setName(this.exprParser.name());
            }

            if (this.lexer.token() == Token.VALUES) {
               this.lexer.nextToken();
               this.accept(Token.LPAREN);

               while(true) {
                  partition.getValueList().add(this.exprParser.expr());
                  if (this.lexer.token() != Token.COMMA) {
                     this.accept(Token.RPAREN);
                     break;
                  }

                  this.lexer.nextToken();
               }
            } else {
               if (this.lexer.token() == Token.START) {
                  partition.setStart(true);
                  this.lexer.nextToken();
                  this.accept(Token.LPAREN);
                  if (this.lexer.token() == Token.IDENTIFIER) {
                     partition.setStartDataType(this.exprParser.name());
                  }

                  partition.setStartValue(this.exprParser.expr());
                  this.accept(Token.RPAREN);
                  if (this.lexer.identifierEquals("INCLUSIVE")) {
                     partition.setStartInclusive(true);
                     this.lexer.nextToken();
                  } else if (this.lexer.identifierEquals("EXCLUSIVE")) {
                     partition.setStartExclusive(true);
                     this.lexer.nextToken();
                  }
               }

               if (this.lexer.token() == Token.END) {
                  partition.setEnd(true);
                  this.lexer.nextToken();
                  this.accept(Token.LPAREN);
                  if (this.lexer.token() == Token.IDENTIFIER) {
                     partition.setStartDataType(this.exprParser.name());
                  }

                  partition.setEndValue(this.exprParser.expr());
                  this.accept(Token.RPAREN);
                  if (this.lexer.identifierEquals("INCLUSIVE")) {
                     partition.setEndInclusive(true);
                     this.lexer.nextToken();
                  } else if (this.lexer.identifierEquals("EXCLUSIVE")) {
                     partition.setEndExclusive(true);
                     this.lexer.nextToken();
                  }
               }

               if (this.lexer.identifierEquals("EVERY")) {
                  partition.setEvery(true);
                  this.lexer.nextToken();
                  this.accept(Token.LPAREN);
                  if (this.lexer.token() == Token.IDENTIFIER) {
                     partition.setEveryDataType(this.exprParser.name());
                  }

                  partition.setEveryValue(this.exprParser.expr());
                  this.accept(Token.RPAREN);
               }
            }

            if (this.lexer.token() == Token.WITH) {
               partition.setWith(true);
               this.lexer.nextToken();
               this.accept(Token.LPAREN);

               while(true) {
                  SQLUpdateSetItem item = this.exprParser.parseUpdateSetItem();
                  partition.getWithList().add(item);
                  if (this.lexer.token() != Token.COMMA) {
                     this.accept(Token.RPAREN);
                     break;
                  }

                  this.lexer.nextToken();
               }
            }

            if (this.lexer.token() == Token.TABLESPACE) {
               this.lexer.nextToken();
               partition.setTableSpace(this.exprParser.name());
            }
         }

         if (this.lexer.token() != Token.COMMA) {
            boolean hasDefault = false;

            for(GaussSQLPartition spec : specList) {
               if (spec.getName() != null && spec.getName().equals(defaultName)) {
                  spec.setIfDefault(true);
                  hasDefault = true;
               } else {
                  spec.setIfDefault(false);
               }
            }

            if (defaultName != null && !hasDefault) {
               GaussSQLPartition spec = new GaussSQLPartition();
               spec.setName(defaultName);
               spec.setIfDefault(true);
               specList.add(spec);
            }

            return specList;
         }

         this.lexer.nextToken();
      }
   }
}
