package com.alibaba.druid.sql.dialect.greenplum.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.greenplum.ast.GPSQLIndexSpec;
import com.alibaba.druid.sql.dialect.greenplum.ast.GPSQLPartition;
import com.alibaba.druid.sql.dialect.greenplum.ast.GPSQLPartitionBy;
import com.alibaba.druid.sql.dialect.greenplum.ast.expr.GPBoxExpr;
import com.alibaba.druid.sql.dialect.greenplum.ast.expr.GPCidrExpr;
import com.alibaba.druid.sql.dialect.greenplum.ast.expr.GPCircleExpr;
import com.alibaba.druid.sql.dialect.greenplum.ast.expr.GPColumnSimpleDefinitionExpr;
import com.alibaba.druid.sql.dialect.greenplum.ast.expr.GPExtractExpr;
import com.alibaba.druid.sql.dialect.greenplum.ast.expr.GPInetExpr;
import com.alibaba.druid.sql.dialect.greenplum.ast.expr.GPLineSegmentsExpr;
import com.alibaba.druid.sql.dialect.greenplum.ast.expr.GPMacAddrExpr;
import com.alibaba.druid.sql.dialect.greenplum.ast.expr.GPOptionValue;
import com.alibaba.druid.sql.dialect.greenplum.ast.expr.GPPointExpr;
import com.alibaba.druid.sql.dialect.greenplum.ast.expr.GPPolygonExpr;
import com.alibaba.druid.sql.dialect.greenplum.ast.expr.GPSQLObjectCollection;
import com.alibaba.druid.sql.dialect.greenplum.ast.expr.GPSchemaTables;
import com.alibaba.druid.sql.dialect.greenplum.ast.expr.GPTypeCastExpr;
import com.alibaba.druid.sql.dialect.greenplum.ast.expr.constraint.GPConstraint;
import com.alibaba.druid.sql.dialect.greenplum.ast.expr.constraint.GPStorageParameter;
import com.alibaba.druid.sql.dialect.greenplum.ast.expr.tablesource.GPExprTableSource;
import com.alibaba.druid.sql.dialect.greenplum.ast.expr.tablesource.GPFunctionTableSource;
import com.alibaba.druid.sql.dialect.greenplum.ast.expr.tablesource.GPMethodInvokeTableSource;
import com.alibaba.druid.sql.dialect.greenplum.ast.expr.tablesource.GPRowsFromTableSource;
import com.alibaba.druid.sql.dialect.greenplum.ast.expr.tablesource.GPSubqueryTableSource;
import com.alibaba.druid.sql.dialect.greenplum.ast.expr.tablesource.GPValuesTableSource;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPAlterDatabaseStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPAlterIndexStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPAlterSchemaStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPAlterSequenceStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPAlterTableStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPAlterViewStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPConnectToStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPCreateDatabaseStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPCreateIndexStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPCreateSchemaStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPCreateSeqenceStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPCreateTableSpaceStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPCreateTableStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPCreateViewStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPDeleteStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPDropSchemaStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPDropSequenceStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPGrantStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPInsertStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPSelectQueryBlock;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPSelectStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPShowStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPStartTransactionStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.GPUpdateStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.alterTable.GPAlterTableAddColumn;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.alterTable.GPAlterTableAddConstraint;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.alterTable.GPAlterTableAlterColumn;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.alterTable.GPAlterTableAlterColumnOptions;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.alterTable.GPAlterTableCluster;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.alterTable.GPAlterTableDisableEnabelTrigger;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.alterTable.GPAlterTableDropColumn;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.alterTable.GPAlterTableDropConstraint;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.alterTable.GPAlterTableInheriteOrNotParentTable;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.alterTable.GPAlterTableOf;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.alterTable.GPAlterTableRenameColumn;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.alterTable.GPAlterTableRenameConstraint;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.alterTable.GPAlterTableRenameTo;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.alterTable.GPAlterTableSetNewTableSpace;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.alterTable.GPAlterTableSetReset;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.alterTable.GPAlterTableSetSchema;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.alterTable.GPAlterTableSetTableSpace;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.alterTable.GPAlterTableSetWith;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.alterTable.GPAlterTableValidateConstraint;
import com.alibaba.druid.sql.dialect.greenplum.ast.stmt.alterTable.GPColumnDefinition;
import com.alibaba.druid.sql.repository.SchemaRepository;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.alibaba.druid.stat.TableStat;
import com.alibaba.druid.util.PGUtils;

public class GPSchemaStatVisitor extends SchemaStatVisitor implements GPASTVisitor {
   public GPSchemaStatVisitor() {
      super(DbType.greenplum);
   }

   public GPSchemaStatVisitor(SchemaRepository repository) {
      super(repository);
   }

   public DbType getDbType() {
      return DbType.greenplum;
   }

   public void endVisit(GPSelectQueryBlock x) {
   }

   public boolean visit(GPSelectQueryBlock x) {
      return true;
   }

   public void endVisit(GPSelectQueryBlock.FetchClause x) {
   }

   public boolean visit(GPSelectQueryBlock.FetchClause x) {
      return true;
   }

   public void endVisit(GPSelectQueryBlock.ForClause x) {
   }

   public boolean visit(GPSelectQueryBlock.ForClause x) {
      return true;
   }

   public void endVisit(GPDeleteStatement x) {
   }

   public boolean visit(GPDeleteStatement x) {
      if (this.repository != null && x.getParent() == null) {
         this.repository.resolve((SQLStatement)x);
      }

      if (x.getWith() != null) {
         x.getWith().accept(this);
      }

      SQLTableSource using = x.getUsing();
      if (using != null) {
         using.accept(this);
      }

      x.putAttribute("_original_use_mode", this.getMode());
      this.setMode(x, TableStat.Mode.Delete);
      TableStat stat = this.getTableStat(x.getTableName());
      stat.incrementDeleteCount();
      this.accept(x.getWhere());
      return false;
   }

   public void endVisit(GPInsertStatement x) {
   }

   public boolean visit(GPInsertStatement x) {
      if (this.repository != null && x.getParent() == null) {
         this.repository.resolve((SQLStatement)x);
      }

      if (x.getWith() != null) {
         x.getWith().accept(this);
      }

      x.putAttribute("_original_use_mode", this.getMode());
      this.setMode(x, TableStat.Mode.Insert);
      SQLName tableName = x.getTableName();
      TableStat stat = this.getTableStat(tableName);
      stat.incrementInsertCount();
      this.accept(x.getColumns());
      this.accept(x.getQuery());
      return false;
   }

   public void endVisit(GPSelectStatement x) {
   }

   public boolean visit(GPSelectStatement x) {
      return this.visit((SQLSelectStatement)x);
   }

   public void endVisit(GPUpdateStatement x) {
   }

   public boolean isPseudoColumn(long hash) {
      return PGUtils.isPseudoColumn(hash);
   }

   public boolean visit(GPUpdateStatement x) {
      if (this.repository != null && x.getParent() == null) {
         this.repository.resolve((SQLStatement)x);
      }

      if (x.getWith() != null) {
         x.getWith().accept(this);
      }

      TableStat stat = this.getTableStat(x.getTableName());
      stat.incrementUpdateCount();
      this.accept(x.getFrom());
      this.accept(x.getItems());
      this.accept(x.getWhere());
      return false;
   }

   public void endVisit(GPFunctionTableSource x) {
   }

   public boolean visit(GPFunctionTableSource x) {
      return true;
   }

   public void endVisit(GPTypeCastExpr x) {
   }

   public boolean visit(GPTypeCastExpr x) {
      x.getExpr().accept(this);
      return false;
   }

   public void endVisit(GPExtractExpr x) {
   }

   public boolean visit(GPExtractExpr x) {
      return true;
   }

   public void endVisit(GPBoxExpr x) {
   }

   public boolean visit(GPBoxExpr x) {
      return true;
   }

   public void endVisit(GPPointExpr x) {
   }

   public boolean visit(GPPointExpr x) {
      return true;
   }

   public void endVisit(GPMacAddrExpr x) {
   }

   public boolean visit(GPMacAddrExpr x) {
      return true;
   }

   public void endVisit(GPInetExpr x) {
   }

   public boolean visit(GPInetExpr x) {
      return true;
   }

   public void endVisit(GPCidrExpr x) {
   }

   public boolean visit(GPCidrExpr x) {
      return true;
   }

   public void endVisit(GPPolygonExpr x) {
   }

   public boolean visit(GPPolygonExpr x) {
      return true;
   }

   public void endVisit(GPCircleExpr x) {
   }

   public boolean visit(GPCircleExpr x) {
      return true;
   }

   public void endVisit(GPLineSegmentsExpr x) {
   }

   public boolean visit(GPLineSegmentsExpr x) {
      return true;
   }

   public void endVisit(GPShowStatement x) {
   }

   public boolean visit(GPShowStatement x) {
      return false;
   }

   public void endVisit(GPStartTransactionStatement x) {
   }

   public boolean visit(GPStartTransactionStatement x) {
      return false;
   }

   public void endVisit(GPConnectToStatement x) {
   }

   public boolean visit(GPConnectToStatement x) {
      return false;
   }

   public void endVisit(GPCreateSchemaStatement x) {
   }

   public boolean visit(GPCreateSchemaStatement x) {
      return false;
   }

   public void endVisit(GPDropSchemaStatement x) {
   }

   public boolean visit(GPDropSchemaStatement x) {
      return false;
   }

   public void endVisit(GPAlterSchemaStatement x) {
   }

   public boolean visit(GPAlterSchemaStatement x) {
      return false;
   }

   public void endVisit(GPMethodInvokeTableSource x) {
   }

   public boolean visit(GPMethodInvokeTableSource x) {
      return true;
   }

   public void endVisit(GPExprTableSource x) {
   }

   public boolean visit(GPExprTableSource x) {
      return true;
   }

   public void endVisit(GPSubqueryTableSource x) {
   }

   public boolean visit(GPSubqueryTableSource x) {
      return true;
   }

   public void endVisit(GPValuesTableSource x) {
   }

   public boolean visit(GPValuesTableSource x) {
      return true;
   }

   public void endVisit(GPValuesTableSource.ValueRow x) {
   }

   public boolean visit(GPValuesTableSource.ValueRow x) {
      return true;
   }

   public void endVisit(GPSelectQueryBlock.ForClauses x) {
   }

   public boolean visit(GPSelectQueryBlock.ForClauses x) {
      return true;
   }

   public void endVisit(GPColumnSimpleDefinitionExpr x) {
   }

   public boolean visit(GPColumnSimpleDefinitionExpr x) {
      return true;
   }

   public void endVisit(GPRowsFromTableSource x) {
   }

   public boolean visit(GPRowsFromTableSource x) {
      return true;
   }

   public void endVisit(GPAlterDatabaseStatement x) {
   }

   public boolean visit(GPAlterDatabaseStatement x) {
      return true;
   }

   public void endVisit(GPAlterIndexStatement x) {
   }

   public boolean visit(GPAlterIndexStatement x) {
      return true;
   }

   public void endVisit(GPAlterSequenceStatement x) {
   }

   public boolean visit(GPAlterSequenceStatement x) {
      return true;
   }

   public void endVisit(GPAlterTableStatement x) {
   }

   public boolean visit(GPAlterTableStatement x) {
      return true;
   }

   public void endVisit(GPAlterTableRenameColumn x) {
   }

   public boolean visit(GPAlterTableRenameColumn x) {
      return true;
   }

   public void endVisit(GPAlterTableRenameConstraint x) {
   }

   public boolean visit(GPAlterTableRenameConstraint x) {
      return true;
   }

   public void endVisit(GPAlterTableRenameTo x) {
   }

   public boolean visit(GPAlterTableRenameTo x) {
      return true;
   }

   public void endVisit(GPAlterTableSetSchema x) {
   }

   public boolean visit(GPAlterTableSetSchema x) {
      return true;
   }

   public void endVisit(GPAlterTableSetNewTableSpace x) {
   }

   public boolean visit(GPAlterTableSetNewTableSpace x) {
      return true;
   }

   public void endVisit(GPAlterTableSetWith x) {
   }

   public boolean visit(GPAlterTableSetWith x) {
      return true;
   }

   public void endVisit(GPAlterTableAddColumn x) {
   }

   public boolean visit(GPAlterTableAddColumn x) {
      return true;
   }

   public void endVisit(GPAlterTableSetWith.GPAlterTableDistributeByOption x) {
   }

   public boolean visit(GPAlterTableSetWith.GPAlterTableDistributeByOption x) {
      return true;
   }

   public void endVisit(GPAlterTableDropColumn x) {
   }

   public boolean visit(GPAlterTableDropColumn x) {
      return true;
   }

   public void endVisit(GPAlterTableAlterColumn x) {
   }

   public boolean visit(GPAlterTableAlterColumn x) {
      return true;
   }

   public void endVisit(GPAlterTableAlterColumnOptions x) {
   }

   public boolean visit(GPAlterTableAlterColumnOptions x) {
      return true;
   }

   public void endVisit(GPAlterTableAlterColumnOptions.GPAlterTableAlterColumnOptionValue x) {
   }

   public boolean visit(GPAlterTableAlterColumnOptions.GPAlterTableAlterColumnOptionValue x) {
      return true;
   }

   public void endVisit(GPAlterTableAddConstraint x) {
   }

   public boolean visit(GPAlterTableAddConstraint x) {
      return true;
   }

   public void endVisit(GPAlterTableAddConstraint.GPAlterTableAddConstraintUsingIndex x) {
   }

   public boolean visit(GPAlterTableAddConstraint.GPAlterTableAddConstraintUsingIndex x) {
      return true;
   }

   public void endVisit(GPAlterTableValidateConstraint x) {
   }

   public boolean visit(GPAlterTableValidateConstraint x) {
      return true;
   }

   public void endVisit(GPAlterTableDropConstraint x) {
   }

   public boolean visit(GPAlterTableDropConstraint x) {
      return true;
   }

   public void endVisit(GPAlterTableDisableEnabelTrigger x) {
   }

   public boolean visit(GPAlterTableDisableEnabelTrigger x) {
      return true;
   }

   public void endVisit(GPAlterTableCluster x) {
   }

   public boolean visit(GPAlterTableCluster x) {
      return true;
   }

   public void endVisit(GPAlterTableSetReset x) {
   }

   public boolean visit(GPAlterTableSetReset x) {
      return true;
   }

   public void endVisit(GPAlterTableSetReset.StorageParameter x) {
   }

   public boolean visit(GPAlterTableSetReset.StorageParameter x) {
      return true;
   }

   public void endVisit(GPAlterTableInheriteOrNotParentTable x) {
   }

   public boolean visit(GPAlterTableInheriteOrNotParentTable x) {
      return true;
   }

   public void endVisit(GPAlterTableOf x) {
   }

   public boolean visit(GPAlterTableOf x) {
      return true;
   }

   public void endVisit(GPAlterTableSetTableSpace x) {
   }

   public boolean visit(GPAlterTableSetTableSpace x) {
      return true;
   }

   public void endVisit(GPCreateDatabaseStatement x) {
   }

   public boolean visit(GPCreateDatabaseStatement x) {
      return true;
   }

   public void endVisit(GPConstraint x) {
   }

   public boolean visit(GPConstraint x) {
      return true;
   }

   public void endVisit(GPConstraint.GPConstraintCheck x) {
   }

   public boolean visit(GPConstraint.GPConstraintCheck x) {
      return true;
   }

   public void endVisit(GPConstraint.GPUnique x) {
   }

   public boolean visit(GPConstraint.GPUnique x) {
      return true;
   }

   public void endVisit(GPConstraint.GPPrimaryKey x) {
   }

   public boolean visit(GPConstraint.GPPrimaryKey x) {
      return true;
   }

   public void endVisit(GPConstraint.GPForeignKey x) {
   }

   public boolean visit(GPConstraint.GPForeignKey x) {
      return true;
   }

   public void endVisit(GPOptionValue x) {
   }

   public boolean visit(GPOptionValue x) {
      return true;
   }

   public void endVisit(GPStorageParameter x) {
   }

   public boolean visit(GPStorageParameter x) {
      return true;
   }

   public void endVisit(GPConstraint.GPIndexParamaters x) {
   }

   public boolean visit(GPConstraint.GPIndexParamaters x) {
      return true;
   }

   public void endVisit(GPConstraint.GPReference x) {
   }

   public boolean visit(GPConstraint.GPReference x) {
      return true;
   }

   public void endVisit(GPColumnDefinition x) {
   }

   public boolean visit(GPColumnDefinition x) {
      return true;
   }

   public void endVisit(GPCreateTableStatement x) {
   }

   public boolean visit(GPCreateTableStatement x) {
      return true;
   }

   public void endVisit(GPCreateTableStatement.GPTableDistributedBy x) {
   }

   public boolean visit(GPCreateTableStatement.GPTableDistributedBy x) {
      return true;
   }

   public void endVisit(GPSQLObjectCollection x) {
   }

   public boolean visit(GPSQLObjectCollection x) {
      return true;
   }

   public void endVisit(GPSchemaTables x) {
   }

   public boolean visit(GPSchemaTables x) {
      return true;
   }

   public void endVisit(GPGrantStatement x) {
   }

   public boolean visit(GPGrantStatement x) {
      return true;
   }

   public boolean visit(GPAlterViewStatement x) {
      return true;
   }

   public boolean visit(GPCreateSeqenceStatement x) {
      return true;
   }

   public boolean visit(GPCreateTableSpaceStatement x) {
      return true;
   }

   public boolean visit(GPCreateViewStatement x) {
      return true;
   }

   public boolean visit(GPDropSequenceStatement x) {
      return true;
   }

   public boolean visit(GPSQLPartitionBy x) {
      return true;
   }

   public boolean visit(GPSQLPartition x) {
      return true;
   }

   public boolean visit(GPSQLIndexSpec x) {
      return true;
   }

   public boolean visit(GPCreateIndexStatement x) {
      return true;
   }
}
