package com.alibaba.druid.sql.dialect.mariadb.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLAlterStatement;
import com.alibaba.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;

public class MariadbAlterServerStatement extends MariadbStatementImpl implements SQLAlterStatement {
   private SQLName name;
   private SQLExpr user;

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName name) {
      if (name != null) {
         name.setParent(this);
      }

      this.name = name;
   }

   public SQLExpr getUser() {
      return this.user;
   }

   public void setUser(SQLExpr user) {
      if (user != null) {
         user.setParent(this);
      }

      this.user = user;
   }

   public void accept0(MariadbASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
         this.acceptChild(visitor, this.user);
      }

      visitor.endVisit(this);
   }
}
