package com.alibaba.druid.sql.dialect.mysql.ast.expr;

import com.alibaba.druid.FastsqlException;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.IOException;

public class MySqlCharExpr extends SQLCharExpr implements MySqlExpr {
   private String charset;
   private String collate;
   private String type;

   public MySqlCharExpr() {
   }

   public MySqlCharExpr(String text) {
      super(text);
   }

   public MySqlCharExpr(String text, String charset) {
      super(text);
      this.charset = charset;
   }

   public MySqlCharExpr(String text, String charset, String collate) {
      super(text);
      this.charset = charset;
      this.collate = collate;
   }

   public String getCharset() {
      return this.charset;
   }

   public void setCharset(String charset) {
      this.charset = charset;
   }

   public String getCollate() {
      return this.collate;
   }

   public void setCollate(String collate) {
      this.collate = collate;
   }

   public String getType() {
      return this.type;
   }

   public void setType(String type) {
      this.type = type;
   }

   public void output(Appendable buf) {
      try {
         if (this.charset != null) {
            buf.append(this.charset);
            buf.append(' ');
         }

         if (super.text != null) {
            super.output(buf);
         }

         if (this.collate != null) {
            buf.append(" COLLATE ");
            buf.append(this.collate);
         }

      } catch (IOException ex) {
         throw new FastsqlException("output error", ex);
      }
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof MySqlASTVisitor) {
         this.accept0((MySqlASTVisitor)visitor);
      } else {
         visitor.visit((SQLCharExpr)this);
         visitor.endVisit((SQLCharExpr)this);
      }

   }

   public void accept0(MySqlASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public String toString() {
      StringBuffer buf = new StringBuffer();
      this.output(buf);
      return buf.toString();
   }

   public MySqlCharExpr clone() {
      MySqlCharExpr x = new MySqlCharExpr(this.text);
      x.collate = this.collate;
      x.charset = this.charset;
      x.type = this.type;
      return x;
   }
}
