package com.alibaba.druid.sql.dialect.mysql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MySqlCheckTableStatement extends MySqlStatementImpl {
   private final List<SQLExprTableSource> tables = new ArrayList();
   private List<SQLExpr> identifiedList = new ArrayList();

   public void addTable(SQLExprTableSource table) {
      if (table != null) {
         table.setParent(this);
         this.tables.add(table);
      }
   }

   public List<SQLExprTableSource> getTables() {
      return this.tables;
   }

   public void accept0(MySqlASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.tables);
      }

      visitor.endVisit(this);
   }

   public List<SQLExpr> getIdentifiedList() {
      return this.identifiedList;
   }

   public void setIdentifiedList(List<SQLExpr> identifiedList) {
      this.identifiedList = identifiedList;
   }
}
