package com.alibaba.druid.sql.dialect.mysql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MySqlLoadXmlStatement extends MySqlStatementImpl {
   private boolean lowPriority = false;
   private boolean concurrent = false;
   private boolean local = false;
   private SQLLiteralExpr fileName;
   private boolean replicate = false;
   private boolean ignore = false;
   private SQLName tableName;
   private String charset;
   private SQLExpr rowsIdentifiedBy;
   private SQLExpr ignoreLinesNumber;
   private final List<SQLExpr> setList = new ArrayList();
   private List<SQLExpr> columns = new ArrayList();

   public SQLExpr getRowsIdentifiedBy() {
      return this.rowsIdentifiedBy;
   }

   public void setRowsIdentifiedBy(SQLExpr rowsIdentifiedBy) {
      this.rowsIdentifiedBy = rowsIdentifiedBy;
   }

   public boolean isLowPriority() {
      return this.lowPriority;
   }

   public void setLowPriority(boolean lowPriority) {
      this.lowPriority = lowPriority;
   }

   public boolean isConcurrent() {
      return this.concurrent;
   }

   public void setConcurrent(boolean concurrent) {
      this.concurrent = concurrent;
   }

   public boolean isLocal() {
      return this.local;
   }

   public void setLocal(boolean local) {
      this.local = local;
   }

   public SQLLiteralExpr getFileName() {
      return this.fileName;
   }

   public void setFileName(SQLLiteralExpr fileName) {
      this.fileName = fileName;
   }

   public boolean isReplicate() {
      return this.replicate;
   }

   public void setReplicate(boolean replicate) {
      this.replicate = replicate;
   }

   public boolean isIgnore() {
      return this.ignore;
   }

   public void setIgnore(boolean ignore) {
      this.ignore = ignore;
   }

   public SQLName getTableName() {
      return this.tableName;
   }

   public void setTableName(SQLName tableName) {
      this.tableName = tableName;
   }

   public String getCharset() {
      return this.charset;
   }

   public void setCharset(String charset) {
      this.charset = charset;
   }

   public SQLExpr getIgnoreLinesNumber() {
      return this.ignoreLinesNumber;
   }

   public void setIgnoreLinesNumber(SQLExpr ignoreLinesNumber) {
      this.ignoreLinesNumber = ignoreLinesNumber;
   }

   public List<SQLExpr> getSetList() {
      return this.setList;
   }

   public void accept0(MySqlASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.fileName);
         this.acceptChild(visitor, this.tableName);
         this.acceptChild(visitor, this.rowsIdentifiedBy);
         this.acceptChild(visitor, this.ignoreLinesNumber);
         this.acceptChild(visitor, this.setList);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.fileName != null) {
         children.add(this.fileName);
      }

      if (this.tableName != null) {
         children.add(this.tableName);
      }

      if (this.rowsIdentifiedBy != null) {
         children.add(this.rowsIdentifiedBy);
      }

      if (this.ignoreLinesNumber != null) {
         children.add(this.ignoreLinesNumber);
      }

      children.addAll(this.setList);
      return children;
   }

   public List<SQLExpr> getColumns() {
      return this.columns;
   }

   public void setColumns(List<SQLExpr> columns) {
      this.columns = columns;
   }
}
