package com.alibaba.druid.sql.dialect.mysql.ast.statement;

import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.statement.SQLTableSourceImpl;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class MySqlUpdateTableSource extends SQLTableSourceImpl {
   private MySqlUpdateStatement update;

   public MySqlUpdateTableSource(MySqlUpdateStatement update) {
      this.update = update;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof MySqlASTVisitor) {
         this.accept0((MySqlASTVisitor)visitor);
      } else {
         throw new IllegalArgumentException("not support visitor type : " + visitor.getClass().getName());
      }
   }

   public void accept0(MySqlASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.update);
      }

      visitor.endVisit(this);
   }

   public MySqlUpdateStatement getUpdate() {
      return this.update;
   }

   public void setUpdate(MySqlUpdateStatement update) {
      this.update = update;
   }

   public MySqlUpdateTableSource clone() {
      MySqlUpdateTableSource x = new MySqlUpdateTableSource(this.update);
      x.setAlias(this.alias);
      if (this.flashback != null) {
         x.setFlashback(this.flashback.clone());
      }

      if (this.hints != null) {
         for(SQLHint e : this.hints) {
            SQLHint e2 = e.clone();
            e2.setParent(x);
            x.getHints().add(e2);
         }
      }

      return x;
   }
}
