package com.alibaba.druid.sql.dialect.oracle.ast.stmt;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleSQLObjectImpl;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;

public abstract class OracleSelectRestriction extends OracleSQLObjectImpl {
   protected SQLName constraint;

   public SQLName getConstraint() {
      return this.constraint;
   }

   public void setConstraint(SQLName constraint) {
      if (constraint != null) {
         constraint.setParent(this);
      }

      this.constraint = constraint;
   }

   public static class CheckOption extends OracleSelectRestriction {
      public void accept0(OracleASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.constraint);
         }

         visitor.endVisit(this);
      }

      public CheckOption clone() {
         CheckOption x = new CheckOption();
         if (this.constraint != null) {
            x.setConstraint(this.constraint.clone());
         }

         return x;
      }
   }

   public static class ReadOnly extends OracleSelectRestriction {
      public void accept0(OracleASTVisitor visitor) {
         visitor.visit(this);
         visitor.endVisit(this);
      }

      public ReadOnly clone() {
         ReadOnly x = new ReadOnly();
         return x;
      }
   }
}
