package com.alibaba.druid.sql.dialect.oracle.parser;

import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLParameter;
import com.alibaba.druid.sql.ast.SQLStatement;
import java.util.ArrayList;
import java.util.List;

public class OracleProcedureDataType extends SQLDataTypeImpl {
   private boolean isStatic = false;
   private final List<SQLParameter> parameters = new ArrayList();
   private SQLStatement block;

   public boolean isStatic() {
      return this.isStatic;
   }

   public void setStatic(boolean aStatic) {
      this.isStatic = aStatic;
   }

   public List<SQLParameter> getParameters() {
      return this.parameters;
   }

   public OracleProcedureDataType clone() {
      OracleProcedureDataType x = new OracleProcedureDataType();
      this.cloneTo(x);
      x.isStatic = this.isStatic;

      for(SQLParameter parameter : this.parameters) {
         SQLParameter p2 = parameter.clone();
         p2.setParent(x);
         x.parameters.add(p2);
      }

      return x;
   }

   public SQLStatement getBlock() {
      return this.block;
   }

   public void setBlock(SQLStatement block) {
      if (block != null) {
         block.setParent(this);
      }

      this.block = block;
   }
}
