package com.alibaba.druid.sql.dialect.postgresql.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLCreateDatabaseStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.PGSQLObject;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class PGCreateDatabaseStatement extends SQLCreateDatabaseStatement implements PGSQLObject {
   private SQLExpr owner;
   private SQLExpr template;
   private SQLExpr encoding;
   private SQLExpr lcCollate;
   private SQLExpr ctype;
   private SQLExpr tablespace;
   private SQLExpr limit;

   public PGCreateDatabaseStatement() {
      this.dbType = DbType.postgresql;
   }

   public SQLExpr getOwner() {
      return this.owner;
   }

   public void setOwner(SQLExpr owner) {
      this.owner = owner;
      owner.setParent(this);
   }

   public SQLExpr getTemplate() {
      return this.template;
   }

   public void setTemplate(SQLExpr template) {
      this.template = template;
      template.setParent(this);
   }

   public SQLExpr getEncoding() {
      return this.encoding;
   }

   public void setEncoding(SQLExpr encoding) {
      this.encoding = encoding;
      encoding.setParent(this);
   }

   public SQLExpr getLcCollate() {
      return this.lcCollate;
   }

   public void setLcCollate(SQLExpr lcCollate) {
      this.lcCollate = lcCollate;
      lcCollate.setParent(this);
   }

   public SQLExpr getCtype() {
      return this.ctype;
   }

   public void setCtype(SQLExpr ctype) {
      this.ctype = ctype;
      ctype.setParent(this);
   }

   public SQLExpr getTablespace() {
      return this.tablespace;
   }

   public void setTablespace(SQLExpr tablespace) {
      this.tablespace = tablespace;
      tablespace.setParent(this);
   }

   public SQLExpr getLimit() {
      return this.limit;
   }

   public void setLimit(SQLExpr limit) {
      this.limit = limit;
      limit.setParent(this);
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((PGASTVisitor)visitor);
   }

   public void accept0(PGASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.owner);
         this.acceptChild(visitor, this.template);
         this.acceptChild(visitor, this.encoding);
         this.acceptChild(visitor, this.lcCollate);
         this.acceptChild(visitor, this.ctype);
         this.acceptChild(visitor, this.tablespace);
         this.acceptChild(visitor, this.limit);
      }

      visitor.endVisit(this);
   }

   public PGCreateDatabaseStatement clone() {
      PGCreateDatabaseStatement c = new PGCreateDatabaseStatement();
      if (this.owner != null) {
         c.setOwner(this.owner.clone());
      }

      if (this.template != null) {
         c.setTemplate(this.template.clone());
      }

      if (this.encoding != null) {
         c.setEncoding(this.encoding.clone());
      }

      if (this.lcCollate != null) {
         c.setLcCollate(this.lcCollate.clone());
      }

      if (this.ctype != null) {
         c.setCtype(this.ctype.clone());
      }

      if (this.tablespace != null) {
         c.setTablespace(this.tablespace.clone());
      }

      if (this.limit != null) {
         c.setLimit(this.limit.clone());
      }

      return c;
   }
}
