package com.alibaba.druid.sql.dialect.spark.ast.statement;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.dialect.spark.visitor.SparkVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class SparkRefreshStatement extends SQLStatementImpl implements SparkStatement {
   private SQLExpr name;
   private Type type;

   public SparkRefreshStatement() {
      super(DbType.spark);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof SparkVisitor) {
         this.accept0((SparkVisitor)visitor);
      } else {
         super.accept0(visitor);
      }

   }

   public void accept0(SparkVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v, this.name);
      }

      v.endVisit(this);
   }

   public Type getType() {
      return this.type;
   }

   public void setType(Type type) {
      this.type = type;
   }

   public SQLExpr getName() {
      return this.name;
   }

   public void setName(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.name = x;
   }

   public static enum Type {
      TABLE("TABLE"),
      FUNCTION("FUNCTION"),
      RESOURCE_PATH("RESOURCE_PATH");

      public final String name;

      private Type(String name) {
         this.name = name;
      }
   }
}
