package com.alibaba.druid.sql.visitor.functions;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.visitor.SQLEvalVisitor;
import java.util.List;

public class Lpad implements Function {
   public static final Lpad instance = new Lpad();

   public Object eval(SQLEvalVisitor visitor, SQLMethodInvokeExpr x) {
      List<SQLExpr> params = x.getArguments();
      int paramSize = params.size();
      if (paramSize != 3) {
         return SQLEvalVisitor.EVAL_ERROR;
      } else {
         SQLExpr param0 = (SQLExpr)params.get(0);
         SQLExpr param1 = (SQLExpr)params.get(1);
         SQLExpr param2 = (SQLExpr)params.get(2);
         param0.accept(visitor);
         param1.accept(visitor);
         param2.accept(visitor);
         Object param0Value = param0.getAttributes().get("eval.value");
         Object param1Value = param1.getAttributes().get("eval.value");
         Object param2Value = param2.getAttributes().get("eval.value");
         if (param0Value != null && param1Value != null && param2Value != null) {
            String strValue0 = param0Value.toString();
            int len = ((Number)param1Value).intValue();
            String strValue1 = param2Value.toString();
            String result = strValue0;
            if (strValue0.length() > len) {
               return strValue0.substring(0, len);
            } else {
               while(result.length() < len) {
                  result = strValue1 + result;
               }

               return result;
            }
         } else {
            return SQLEvalVisitor.EVAL_ERROR;
         }
      }
   }
}
