package com.alibaba.druid.sql.visitor.functions;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.visitor.SQLEvalVisitor;

public class Trim implements Function {
   public static final Trim instance = new Trim();

   public Object eval(SQLEvalVisitor visitor, SQLMethodInvokeExpr x) {
      if (x.getArguments().size() != 1) {
         return SQLEvalVisitor.EVAL_ERROR;
      } else {
         SQLExpr param0 = (SQLExpr)x.getArguments().get(0);
         param0.accept(visitor);
         Object param0Value = param0.getAttributes().get("eval.value");
         if (param0Value == null) {
            return SQLEvalVisitor.EVAL_ERROR;
         } else {
            String strValue = param0Value.toString();
            String result = strValue.trim();
            return result;
         }
      }
   }
}
