package com.alibaba.druid.util.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public abstract class ResultSetBase implements ResultSet {
   protected boolean closed = false;
   protected boolean wasNull = false;
   private SQLWarning warning;
   private String cursorName;
   private int fetchSize = 0;
   private int fetchDirection = 0;
   protected Statement statement;
   protected ResultSetMetaData metaData;

   public ResultSetBase(Statement statement) {
      this.statement = statement;
   }

   public boolean isClosed() throws SQLException {
      return this.closed;
   }

   public void updateNString(int columnIndex, String x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateNString(String columnLabel, String x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateNClob(int columnIndex, NClob x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateNClob(String columnLabel, NClob x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public NClob getNClob(int columnIndex) throws SQLException {
      return (NClob)this.getObject(columnIndex);
   }

   public NClob getNClob(String columnLabel) throws SQLException {
      return (NClob)this.getObject(columnLabel);
   }

   public SQLXML getSQLXML(int columnIndex) throws SQLException {
      return (SQLXML)this.getObject(columnIndex);
   }

   public SQLXML getSQLXML(String columnLabel) throws SQLException {
      return (SQLXML)this.getObject(columnLabel);
   }

   public void updateSQLXML(int columnIndex, SQLXML x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateSQLXML(String columnLabel, SQLXML x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public String getNString(int columnIndex) throws SQLException {
      return (String)this.getObject(columnIndex);
   }

   public String getNString(String columnLabel) throws SQLException {
      return (String)this.getObject(columnLabel);
   }

   public Reader getNCharacterStream(int columnIndex) throws SQLException {
      return (Reader)this.getObject(columnIndex);
   }

   public Reader getNCharacterStream(String columnLabel) throws SQLException {
      return (Reader)this.getObject(columnLabel);
   }

   public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateNCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateBlob(int columnIndex, InputStream x, long length) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateBlob(String columnLabel, InputStream x, long length) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateClob(int columnIndex, Reader x, long length) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateClob(String columnLabel, Reader x, long length) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateNClob(int columnIndex, Reader x, long length) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateNClob(String columnLabel, Reader x, long length) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateNCharacterStream(String columnLabel, Reader x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateCharacterStream(String columnLabel, Reader x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateBlob(int columnIndex, InputStream x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateBlob(String columnLabel, InputStream x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateClob(int columnIndex, Reader x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateClob(String columnLabel, Reader x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateNClob(int columnIndex, Reader x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateNClob(String columnLabel, Reader x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
      throw new SQLFeatureNotSupportedException();
   }

   public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
      throw new SQLFeatureNotSupportedException();
   }

   public <T> T unwrap(Class<T> iface) throws SQLException {
      if (iface == null) {
         return null;
      } else {
         return (T)(iface.isInstance(this) ? this : null);
      }
   }

   public boolean isWrapperFor(Class<?> iface) throws SQLException {
      return iface == null ? false : iface.isInstance(this);
   }

   public void close() throws SQLException {
      this.closed = true;
   }

   public boolean wasNull() throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else {
         return this.wasNull;
      }
   }

   public Object getObjectInternal(int columnIndex) throws SQLException {
      if (this.getMetaData() != null) {
         String columnName = this.getMetaData().getColumnName(columnIndex);
         return this.getObject(columnName);
      } else {
         return null;
      }
   }

   public Object getObject(int columnIndex) throws SQLException {
      Object obj = this.getObjectInternal(columnIndex);
      this.wasNull = obj == null;
      return obj;
   }

   public Object getObject(String columnLabel) throws SQLException {
      return this.getObject(this.findColumn(columnLabel));
   }

   public int findColumn(String columnLabel) throws SQLException {
      return Integer.parseInt(columnLabel);
   }

   public Reader getCharacterStream(int columnIndex) throws SQLException {
      return (Reader)this.getObject(columnIndex);
   }

   public Reader getCharacterStream(String columnLabel) throws SQLException {
      return (Reader)this.getObject(columnLabel);
   }

   public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
      return (BigDecimal)this.getObject(columnIndex);
   }

   public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
      return this.getBigDecimal(this.findColumn(columnLabel));
   }

   public void clearWarnings() throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else {
         this.warning = null;
      }
   }

   public void setWarning(SQLWarning warning) {
      this.warning = warning;
   }

   public String getCursorName() throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else {
         return this.cursorName;
      }
   }

   public void setCursorName(String cursorName) {
      this.cursorName = cursorName;
   }

   public SQLWarning getWarnings() throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else {
         return this.warning;
      }
   }

   public void setFetchDirection(int direction) throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else {
         this.fetchDirection = direction;
      }
   }

   public int getFetchDirection() throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else {
         return this.fetchDirection;
      }
   }

   public void setFetchSize(int rows) throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else {
         this.fetchSize = rows;
      }
   }

   public int getFetchSize() throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else {
         return this.fetchSize;
      }
   }

   public boolean rowUpdated() throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else {
         return false;
      }
   }

   public boolean rowInserted() throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else {
         return false;
      }
   }

   public boolean rowDeleted() throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else {
         return false;
      }
   }

   public void updateNull(int columnIndex) throws SQLException {
      this.updateObject(columnIndex, (Object)null);
   }

   public void updateBoolean(int columnIndex, boolean x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateByte(int columnIndex, byte x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateShort(int columnIndex, short x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateInt(int columnIndex, int x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateLong(int columnIndex, long x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateFloat(int columnIndex, float x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateDouble(int columnIndex, double x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateString(int columnIndex, String x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateBytes(int columnIndex, byte[] x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateDate(int columnIndex, Date x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateTime(int columnIndex, Time x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateNull(String columnLabel) throws SQLException {
      this.updateObject(columnLabel, (Object)null);
   }

   public void updateBoolean(String columnLabel, boolean x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateByte(String columnLabel, byte x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateShort(String columnLabel, short x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateInt(String columnLabel, int x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateLong(String columnLabel, long x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateFloat(String columnLabel, float x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateDouble(String columnLabel, double x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateString(String columnLabel, String x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateBytes(String columnLabel, byte[] x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateDate(String columnLabel, Date x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateTime(String columnLabel, Time x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
      this.updateObject(columnLabel, reader);
   }

   public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateObject(String columnLabel, Object x) throws SQLException {
      this.updateObject(this.findColumn(columnLabel), x);
   }

   public void insertRow() throws SQLException {
      if (this.closed) {
         throw new SQLException("resultSet closed");
      }
   }

   public void updateRow() throws SQLException {
      if (this.closed) {
         throw new SQLException("resultSet closed");
      }
   }

   public void deleteRow() throws SQLException {
      if (this.closed) {
         throw new SQLException("resultSet closed");
      }
   }

   public void refreshRow() throws SQLException {
      if (this.closed) {
         throw new SQLException("resultSet closed");
      }
   }

   public void cancelRowUpdates() throws SQLException {
      if (this.closed) {
         throw new SQLException("resultSet closed");
      }
   }

   public void moveToInsertRow() throws SQLException {
      if (this.closed) {
         throw new SQLException("resultSet closed");
      }
   }

   public void moveToCurrentRow() throws SQLException {
      if (this.closed) {
         throw new SQLException("resultSet closed");
      }
   }

   public Statement getStatement() throws SQLException {
      if (this.closed) {
         throw new SQLException("resultSet closed");
      } else {
         return this.statement;
      }
   }

   public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
      return this.getObject(columnIndex);
   }

   public Ref getRef(int columnIndex) throws SQLException {
      return (Ref)this.getObject(columnIndex);
   }

   public Blob getBlob(int columnIndex) throws SQLException {
      return (Blob)this.getObject(columnIndex);
   }

   public Clob getClob(int columnIndex) throws SQLException {
      return (Clob)this.getObject(columnIndex);
   }

   public Array getArray(int columnIndex) throws SQLException {
      return (Array)this.getObject(columnIndex);
   }

   public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
      return this.getObject(columnLabel);
   }

   public Ref getRef(String columnLabel) throws SQLException {
      return (Ref)this.getObject(columnLabel);
   }

   public Blob getBlob(String columnLabel) throws SQLException {
      return (Blob)this.getObject(columnLabel);
   }

   public Clob getClob(String columnLabel) throws SQLException {
      return (Clob)this.getObject(columnLabel);
   }

   public Array getArray(String columnLabel) throws SQLException {
      return (Array)this.getObject(columnLabel);
   }

   public Date getDate(int columnIndex, Calendar cal) throws SQLException {
      return (Date)this.getObject(columnIndex);
   }

   public Date getDate(String columnLabel, Calendar cal) throws SQLException {
      return (Date)this.getObject(columnLabel);
   }

   public Time getTime(int columnIndex, Calendar cal) throws SQLException {
      return (Time)this.getObject(columnIndex);
   }

   public Time getTime(String columnLabel, Calendar cal) throws SQLException {
      return (Time)this.getObject(columnLabel);
   }

   public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
      return (Timestamp)this.getObject(columnIndex);
   }

   public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
      return (Timestamp)this.getObject(columnLabel);
   }

   public URL getURL(int columnIndex) throws SQLException {
      return (URL)this.getObject(columnIndex);
   }

   public URL getURL(String columnLabel) throws SQLException {
      return (URL)this.getObject(columnLabel);
   }

   public void updateRef(int columnIndex, Ref x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateRef(String columnLabel, Ref x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateBlob(int columnIndex, Blob x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateBlob(String columnLabel, Blob x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateClob(int columnIndex, Clob x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateClob(String columnLabel, Clob x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public void updateArray(int columnIndex, Array x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateArray(String columnLabel, Array x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public RowId getRowId(int columnIndex) throws SQLException {
      return (RowId)this.getObject(columnIndex);
   }

   public RowId getRowId(String columnLabel) throws SQLException {
      return (RowId)this.getObject(columnLabel);
   }

   public void updateRowId(int columnIndex, RowId x) throws SQLException {
      this.updateObject(columnIndex, x);
   }

   public void updateRowId(String columnLabel, RowId x) throws SQLException {
      this.updateObject(columnLabel, x);
   }

   public int getHoldability() throws SQLException {
      if (this.closed) {
         throw new SQLException("resultSet closed");
      } else {
         return 0;
      }
   }

   public String getString(int columnIndex) throws SQLException {
      return (String)this.getObject(columnIndex);
   }

   public boolean getBoolean(int columnIndex) throws SQLException {
      Object obj = this.getObject(columnIndex);
      return obj == null ? false : (Boolean)obj;
   }

   public byte getByte(int columnIndex) throws SQLException {
      Number number = (Number)this.getObject(columnIndex);
      return number == null ? 0 : number.byteValue();
   }

   public short getShort(int columnIndex) throws SQLException {
      Number number = (Number)this.getObject(columnIndex);
      return number == null ? 0 : number.shortValue();
   }

   public int getInt(int columnIndex) throws SQLException {
      Number number = (Number)this.getObject(columnIndex);
      return number == null ? 0 : number.intValue();
   }

   public long getLong(int columnIndex) throws SQLException {
      Number number = (Number)this.getObject(columnIndex);
      return number == null ? 0L : number.longValue();
   }

   public float getFloat(int columnIndex) throws SQLException {
      Number number = (Number)this.getObject(columnIndex);
      return number == null ? 0.0F : number.floatValue();
   }

   public double getDouble(int columnIndex) throws SQLException {
      Number number = (Number)this.getObject(columnIndex);
      return number == null ? (double)0.0F : number.doubleValue();
   }

   public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
      return (BigDecimal)this.getObject(columnIndex);
   }

   public byte[] getBytes(int columnIndex) throws SQLException {
      return (byte[])this.getObject(columnIndex);
   }

   public Date getDate(int columnIndex) throws SQLException {
      return (Date)this.getObject(columnIndex);
   }

   public Time getTime(int columnIndex) throws SQLException {
      return (Time)this.getObject(columnIndex);
   }

   public Timestamp getTimestamp(int columnIndex) throws SQLException {
      return (Timestamp)this.getObject(columnIndex);
   }

   public InputStream getAsciiStream(int columnIndex) throws SQLException {
      return (InputStream)this.getObject(columnIndex);
   }

   public InputStream getUnicodeStream(int columnIndex) throws SQLException {
      return (InputStream)this.getObject(columnIndex);
   }

   public InputStream getBinaryStream(int columnIndex) throws SQLException {
      return (InputStream)this.getObject(columnIndex);
   }

   public String getString(String columnLabel) throws SQLException {
      return this.getString(this.findColumn(columnLabel));
   }

   public boolean getBoolean(String columnLabel) throws SQLException {
      return this.getBoolean(this.findColumn(columnLabel));
   }

   public byte getByte(String columnLabel) throws SQLException {
      return this.getByte(this.findColumn(columnLabel));
   }

   public short getShort(String columnLabel) throws SQLException {
      return this.getShort(this.findColumn(columnLabel));
   }

   public int getInt(String columnLabel) throws SQLException {
      return this.getInt(this.findColumn(columnLabel));
   }

   public long getLong(String columnLabel) throws SQLException {
      return this.getLong(this.findColumn(columnLabel));
   }

   public float getFloat(String columnLabel) throws SQLException {
      return this.getFloat(this.findColumn(columnLabel));
   }

   public double getDouble(String columnLabel) throws SQLException {
      return this.getDouble(this.findColumn(columnLabel));
   }

   public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
      return this.getBigDecimal(this.findColumn(columnLabel), scale);
   }

   public byte[] getBytes(String columnLabel) throws SQLException {
      return this.getBytes(this.findColumn(columnLabel));
   }

   public Date getDate(String columnLabel) throws SQLException {
      return this.getDate(this.findColumn(columnLabel));
   }

   public Time getTime(String columnLabel) throws SQLException {
      return this.getTime(this.findColumn(columnLabel));
   }

   public Timestamp getTimestamp(String columnLabel) throws SQLException {
      return this.getTimestamp(this.findColumn(columnLabel));
   }

   public InputStream getAsciiStream(String columnLabel) throws SQLException {
      return this.getAsciiStream(this.findColumn(columnLabel));
   }

   public InputStream getUnicodeStream(String columnLabel) throws SQLException {
      return this.getUnicodeStream(this.findColumn(columnLabel));
   }

   public InputStream getBinaryStream(String columnLabel) throws SQLException {
      return this.getBinaryStream(this.findColumn(columnLabel));
   }

   public boolean isBeforeFirst() throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else {
         return false;
      }
   }

   public boolean isAfterLast() throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else {
         return false;
      }
   }

   public boolean isFirst() throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else {
         return false;
      }
   }

   public boolean isLast() throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else {
         return false;
      }
   }

   public void beforeFirst() throws SQLException {
      if (this.closed) {
         throw new SQLException();
      }
   }

   public void afterLast() throws SQLException {
      if (this.closed) {
         throw new SQLException();
      }
   }

   public boolean first() throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else {
         return false;
      }
   }

   public boolean last() throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else {
         return false;
      }
   }

   public int getRow() throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else {
         return 0;
      }
   }

   public boolean absolute(int row) throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else {
         return false;
      }
   }

   public boolean relative(int rows) throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else {
         return false;
      }
   }

   public int getType() throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else {
         return 0;
      }
   }

   public int getConcurrency() throws SQLException {
      if (this.closed) {
         throw new SQLException();
      } else {
         return 0;
      }
   }

   public ResultSetMetaData getMetaData() throws SQLException {
      if (this.closed) {
         throw new SQLException("resultSet closed");
      } else {
         return this.metaData;
      }
   }
}
