package com.palacesun.engine.gateway.netty;

import com.palacesun.engine.gateway.EncryptionGatewayManager;
import com.palacesun.engine.gateway.netty.framework.HttpServer;

public class NettyStartApplicationRunner {
   public static void run() throws Exception {
      InnerThread innerThread = new InnerThread();
      innerThread.start();
   }

   public static Integer getNativeSocketHost() {
      try {
         return Integer.parseInt(EncryptionGatewayManager.getParameterValue("socketport"));
      } catch (Exception var1) {
         return 65534;
      }
   }

   public static class InnerThread extends Thread {
      public void run() {
         HttpServer server = new HttpServer(NettyStartApplicationRunner.getNativeSocketHost());

         try {
            server.start();
         } catch (Exception e) {
            e.printStackTrace();
         }

      }
   }
}
