package com.palacesun.engine.spy;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public class MaskingDriverPoolDataSource implements DataSource, Serializable, Referenceable, ConnectionPoolDataSource {
   protected String url;
   protected String user;
   protected String password;

   public MaskingDriverPoolDataSource() {
   }

   public String getUrl() {
      return this.url;
   }

   public void setUrl(String url) {
      this.url = url;
   }

   public void setURL(String url) {
      this.url = url;
   }

   public String getUser() {
      return this.user;
   }

   public void setUser(String user) {
      this.user = user;
   }

   public String getPassword() {
      return this.password;
   }

   public void setPassword(String password) {
      this.password = password;
   }

   public MaskingDriverPoolDataSource(String url, String user, String password) {
      this.url = url;
      this.user = user;
      this.password = password;
   }

   public Connection getConnection() throws SQLException {
      String var1 = null;
      String var2 = null;
      synchronized(this) {
         var1 = this.user;
         var2 = this.password;
      }

      return this.getConnection(var1, var2);
   }

   public Connection getConnection(String var1, String var2) throws SQLException {
      MaskingDriver maskingDriver = new MaskingDriver();
      Properties properties = new Properties();
      properties.setProperty("user", var1);
      properties.setProperty("password", var2);
      return maskingDriver.connect(this.url, properties);
   }

   public Connection getConnection(String var1, String var2, String var3) throws SQLException {
      MaskingDriver maskingDriver = new MaskingDriver();
      Properties properties = new Properties();
      properties.setProperty("user", var2);
      properties.setProperty("password", var3);
      return maskingDriver.connect(var1, properties);
   }

   public PooledConnection getPooledConnection() throws SQLException {
      String var1 = null;
      String var2 = null;
      synchronized(this) {
         var1 = this.user;
         var2 = this.password;
      }

      return this.getPooledConnection(var1, var2);
   }

   public PooledConnection getPooledConnection(String var1, String var2) throws SQLException {
      Connection var3 = this.getConnection(var1, var2);
      MaskingPool var4 = new MaskingPool(var3);
      if (var2 == null) {
         var2 = this.password;
      }

      return var4;
   }

   public PrintWriter getLogWriter() throws SQLException {
      return null;
   }

   public void setLogWriter(PrintWriter printWriter) throws SQLException {
   }

   public void setLoginTimeout(int i) throws SQLException {
   }

   public int getLoginTimeout() throws SQLException {
      return 0;
   }

    /**
     * Return the parent Logger of all the Loggers used by this data source. This
     * should be the Logger farthest from the root Logger that is
     * still an ancestor of all of the Loggers used by this data source. Configuring
     * this Logger will affect all of the log messages generated by the data source.
     * In the worst case, this may be the root Logger.
     *
     * @return the parent Logger for this data source
     * @throws SQLFeatureNotSupportedException if the data source does not use
     *                                         {@code java.util.logging}
     * @since 1.7
     */
    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    public <T> T unwrap(Class<T> aClass) throws SQLException {
      return null;
   }

   public boolean isWrapperFor(Class<?> aClass) throws SQLException {
      return false;
   }

   public Reference getReference() throws NamingException {
      return null;
   }
}
