package com.palacesun.masking.adapter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.regex.Pattern;

public class StringUtils {
   public static final String EMPTY = "";
   public static final int INDEX_NOT_FOUND = -1;
   private static final int PAD_LIMIT = 8192;
   private static final Pattern WHITESPACE_BLOCK = Pattern.compile("\\s+");
   private static boolean sunAvailable = false;
   private static Method sunDecomposeMethod = null;
   private static final Pattern sunPattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
   private static boolean java6Available = false;
   private static Method java6NormalizeMethod = null;
   private static Object java6NormalizerFormNFD = null;

   public static boolean isEmpty(CharSequence cs) {
      return cs == null || cs.length() == 0;
   }

   public static boolean isNotEmpty(CharSequence cs) {
      return !isEmpty(cs);
   }

   public static boolean isBlank(CharSequence cs) {
      int strLen;
      if (cs != null && (strLen = cs.length()) != 0) {
         for(int i = 0; i < strLen; ++i) {
            if (!Character.isWhitespace(cs.charAt(i))) {
               return false;
            }
         }

         return true;
      } else {
         return true;
      }
   }

   public static String replace(String text, String pattern, String replacement) {
      if (text != null && text.length() != 0) {
         if (pattern != null && pattern.length() > 0) {
            pattern = pattern.replaceAll("\\|", "\\\\|");
         }

         return text.replaceAll(pattern, replacement);
      } else {
         return text;
      }
   }

   public static boolean isNotBlank(CharSequence cs) {
      return !isBlank(cs);
   }

   public static String trim(String str) {
      return str == null ? null : str.trim();
   }

   public static String trimToNull(String str) {
      String ts = trim(str);
      return isEmpty(ts) ? null : ts;
   }

   public static String trimToEmpty(String str) {
      return str == null ? "" : str.trim();
   }

   public static String strip(String str) {
      return strip(str, (String)null);
   }

   public static String stripToNull(String str) {
      if (str == null) {
         return null;
      } else {
         str = strip(str, (String)null);
         return str.length() == 0 ? null : str;
      }
   }

   public static String stripToEmpty(String str) {
      return str == null ? "" : strip(str, (String)null);
   }

   public static String strip(String str, String stripChars) {
      if (isEmpty(str)) {
         return str;
      } else {
         str = stripStart(str, stripChars);
         return stripEnd(str, stripChars);
      }
   }

   public static String stripStart(String str, String stripChars) {
      int strLen;
      if (str != null && (strLen = str.length()) != 0) {
         int start = 0;
         if (stripChars == null) {
            while(start != strLen && Character.isWhitespace(str.charAt(start))) {
               ++start;
            }
         } else {
            if (stripChars.length() == 0) {
               return str;
            }

            while(start != strLen && stripChars.indexOf(str.charAt(start)) != -1) {
               ++start;
            }
         }

         return str.substring(start);
      } else {
         return str;
      }
   }

   public static String stripEnd(String str, String stripChars) {
      int end;
      if (str != null && (end = str.length()) != 0) {
         if (stripChars == null) {
            while(end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
               --end;
            }
         } else {
            if (stripChars.length() == 0) {
               return str;
            }

            while(end != 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
               --end;
            }
         }

         return str.substring(0, end);
      } else {
         return str;
      }
   }

   public static String[] stripAll(String... strs) {
      return stripAll(strs, (String)null);
   }

   public static String[] stripAll(String[] strs, String stripChars) {
      int strsLen;
      if (strs != null && (strsLen = strs.length) != 0) {
         String[] newArr = new String[strsLen];

         for(int i = 0; i < strsLen; ++i) {
            newArr[i] = strip(strs[i], stripChars);
         }

         return newArr;
      } else {
         return strs;
      }
   }

   private static String removeAccentsSUN(CharSequence text) throws IllegalAccessException, InvocationTargetException {
      if (!sunAvailable) {
         throw new IllegalStateException("sun.text.Normalizer is not available");
      } else {
         String result = (String)sunDecomposeMethod.invoke((Object)null, text, Boolean.FALSE, 0);
         result = sunPattern.matcher(result).replaceAll("");
         return result;
      }
   }

   public static boolean equals(CharSequence cs1, CharSequence cs2) {
      return cs1 == null ? cs2 == null : cs1.equals(cs2);
   }
}
