package com.palacesun.masking.log.access;

import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public abstract class SqlBuffer {
   protected String emptyValue = "";
   protected Charset charset = Charset.forName("utf-8");
   private String sql;
   Map<Integer, SqlValue> values;

   public SqlBuffer(String sql) {
      this.sql = sql;
      this.values = new HashMap();
   }

   public String getSafeValue(int parameterIndex) {
      SqlValue value = (SqlValue)this.values.get(parameterIndex);
      return this.getValue(value, value.value);
   }

   public String getRawValue(int parameterIndex) {
      SqlValue value = (SqlValue)this.values.get(parameterIndex);
      return this.getValue(value, value.rawValue);
   }

   public void setValue(int primiteType, int index, String value, String rawValue, int sqlType) {
      this.values.put(index, new SqlValue(primiteType, value, rawValue));
   }

   public void setValue(int primiteType, int index, Object value, Object rawValue) {
      this.values.put(index, new SqlValue(primiteType, value, rawValue));
   }

   public void setValue(int primiteType, int index, Object value) {
      this.values.put(index, new SqlValue(primiteType, value, value));
   }

   public void setValue(int primiteType, int index, Object value, Object rawValue, int targetObjectType) {
      this.values.put(index, new SqlValue(primiteType, value, rawValue));
   }

   public void setValue(int primiteType, int index, InputStream value, int length) {
      this.values.put(index, new SqlValue(primiteType, value, value));
   }

   protected abstract String getValue(SqlValue var1, Object var2);

   public void setValueSqlType(int primiteType, int parameterIndex, int sqlType) {
      SqlValue value = new SqlValue();
      value.intTargetType = sqlType;
      value.primiteType = primiteType;
      this.values.put(parameterIndex, value);
   }

   public void setValue(int primiteType, int parameterIndex, Date x, Calendar cal) {
      this.values.put(parameterIndex, new SqlValue(primiteType, x, x, (String)null, (String)null, (Integer)null, (Long)null, cal));
   }

   public void setValue(int primiteType, int parameterIndex, Time x, Calendar cal) {
      this.values.put(parameterIndex, new SqlValue(primiteType, x, x, (String)null, (String)null, (Integer)null, (Long)null, cal));
   }

   public void setValue(int primiteType, int parameterIndex, Timestamp x, Calendar cal) {
      this.values.put(parameterIndex, new SqlValue(primiteType, x, x, (String)null, (String)null, (Integer)null, (Long)null, cal));
   }

   public void setValue(int primiteType, int parameterIndex, int sqlType, String typeName) {
      this.values.put(parameterIndex, new SqlValue(primiteType, (Object)null, (Object)null, (String)null, (String)null, (Integer)null, (Long)null, (Calendar)null));
   }

   public void setValue(int primiteType, int parameterIndex, Reader value, long length, String type) {
      this.values.put(parameterIndex, new SqlValue(primiteType, value, value, (String)null, type, (Integer)null, (Long)null, (Calendar)null));
   }

   public void setValue(int primiteType, int parameterIndex, Reader value, String type) {
      this.values.put(parameterIndex, new SqlValue(primiteType, value, value, (String)null, type, (Integer)null, (Long)null, (Calendar)null));
   }

   public void setValue(int primiteType, int parameterIndex, InputStream value, String type) {
      this.values.put(parameterIndex, new SqlValue(primiteType, value, value, (String)null, type, (Integer)null, (Long)null, (Calendar)null));
   }

   public void setValue(int primiteType, int parameterIndex, InputStream value, long length, String type) {
      this.values.put(parameterIndex, new SqlValue(primiteType, value, value, (String)null, type, (Integer)null, length, (Calendar)null));
   }

   public void setValue(int primiteType, int parameterIndex, Object value, Object rawValue, int targetSqlType, int scaleOrLength) {
      this.values.put(parameterIndex, new SqlValue(primiteType, value, rawValue, targetSqlType, scaleOrLength));
   }
}
