package com.palacesun.masking.tools.sm4fpe;

import com.palacesun.masking.adapter.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class SM4FPETools {
   public static String generateKey() {
      SM4FPEBase base = new SM4FPEBase();
      return base.generateKey();
   }

   public static String encryptEcb(String hexKey, String a) throws Exception {
      SM4FPEBase base = new SM4FPEBase();
      String out = base.encryptEcb(hexKey, a);
      return out;
   }

   public static String decryptEcb(String hexKey, String input) throws Exception {
      SM4FPEBase base = new SM4FPEBase();
      String out = base.decryptEcb(hexKey, input);
      return out;
   }

   public static Map<String, String> parseInput(String a, String keepfirst, String encdigit, String twoindex) {
      Map<String, String> paraMap = new HashMap();
      String prefix = "";
      String suffix = "";
      String middle = "";
      if (!StringUtils.isBlank(keepfirst)) {
         if (!"0".equals(keepfirst) && !"1".equals(keepfirst)) {
            if ("2".equals(keepfirst)) {
               int first = 0;
               if (StringUtils.isNotBlank(encdigit)) {
                  first = Integer.parseInt(encdigit);
               }

               int last = 0;
               if (StringUtils.isNotBlank(twoindex)) {
                  last = Integer.parseInt(twoindex);
               }

               if (first + last < a.length() && first < a.length() && last < a.length()) {
                  prefix = a.substring(0, first);
                  middle = a.substring(first, a.length() - last);
                  suffix = a.substring(a.length() - last);
               } else {
                  middle = a;
               }
            } else {
               middle = a;
            }
         } else if (StringUtils.isNotBlank(encdigit)) {
            if (Integer.parseInt(encdigit) < a.length()) {
               if (Integer.parseInt(encdigit) != 0) {
                  if ("0".equals(keepfirst)) {
                     prefix = a.substring(0, Integer.parseInt(encdigit));
                     middle = a.substring(Integer.parseInt(encdigit));
                  } else if ("1".equals(keepfirst)) {
                     suffix = a.substring(a.length() - Integer.parseInt(encdigit));
                     middle = a.substring(0, a.length() - Integer.parseInt(encdigit));
                  }
               } else {
                  middle = a;
               }
            } else {
               prefix = a;
               middle = "";
            }
         } else {
            middle = a;
         }
      } else {
         middle = a;
      }

      paraMap.put("prefix", prefix);
      paraMap.put("suffix", suffix);
      paraMap.put("middle", middle);
      return paraMap;
   }

   public static String encryptEcbAuto(String hexKey, String a) throws Exception {
      String out = null;
      if (SM4FPEIdentityNo.check(a)) {
         SM4FPEIdentityNo identityNo = new SM4FPEIdentityNo();
         out = identityNo.encryptEcb(hexKey, a);
         if (!SM4FPEIdentityNo.check(out)) {
            throw new Exception("The encrypt result must be isIdentifyNo. result:" + out);
         }
      } else if (SM4FPECellPhone.check(a)) {
         SM4FPECellPhone phone = new SM4FPECellPhone();
         out = phone.encryptEcb(hexKey, a);
         if (!SM4FPECellPhone.check(out)) {
            throw new Exception("The encrypt result must be isMobilephoneNo. result:" + out);
         }
      } else if (SM4FPEEmail.check(a)) {
         SM4FPEEmail email = new SM4FPEEmail();
         out = email.encryptEcb(hexKey, a);
         if (!SM4FPEEmail.check(out)) {
            throw new Exception("The encrypt result must be isemail. result:" + out);
         }
      } else {
         if (!SM4FPEName.check(a)) {
            throw new Exception("No suitable encryption method found!");
         }

         SM4FPEName name = new SM4FPEName();
         out = name.encryptEcb(hexKey, a);
         if (!SM4FPEName.check(out)) {
            throw new Exception("The encrypt result must be isPersonName. result:" + out);
         }
      }

      return out;
   }

   public static String decryptEcbAuto(String hexKey, String input) throws Exception {
      String out = null;
      if (SM4FPEIdentityNo.check(input)) {
         SM4FPEIdentityNo identityNo = new SM4FPEIdentityNo();
         out = identityNo.decryptEcb(hexKey, input);
      } else if (SM4FPECellPhone.check(input)) {
         SM4FPECellPhone phone = new SM4FPECellPhone();
         out = phone.decryptEcb(hexKey, input);
      } else if (SM4FPEEmail.check(input)) {
         SM4FPEEmail email = new SM4FPEEmail();
         out = email.decryptEcb(hexKey, input);
      } else {
         if (!SM4FPEName.check(input)) {
            throw new Exception("No suitable decrypt method found!");
         }

         SM4FPEName name = new SM4FPEName();
         out = name.decryptEcb(hexKey, input);
      }

      return out;
   }
}
