package com.palacesun.masking.vo;

import util.sqlparse.visitor.common.Objects;

public class Columninfo implements Cloneable {
   private String id;
   private String columnname;
   private String encryptiontype;
   private String secretkey;
   private String isLike;
   private String keepfirst;
   private String encdigit;
   private String twoindex;

   public Columninfo() {
   }

   public Columninfo(String id, String columnname, String encryptiontype, String secretkey, String isLike, String keepfirst, String encdigit, String twoindex) {
      this.id = id;
      this.columnname = columnname;
      this.encryptiontype = encryptiontype;
      this.secretkey = secretkey;
      this.isLike = isLike;
      this.keepfirst = keepfirst;
      this.encdigit = encdigit;
      this.twoindex = twoindex;
   }

   public String getId() {
      return this.id;
   }

   public void setId(String id) {
      this.id = id;
   }

   public void setColumnname(String columnname) {
      this.columnname = columnname;
   }

   public String getColumnname() {
      return this.columnname;
   }

   public void setEncryptiontype(String encryptiontype) {
      this.encryptiontype = encryptiontype;
   }

   public String getEncryptiontype() {
      return this.encryptiontype;
   }

   public void setSecretkey(String secretkey) {
      this.secretkey = secretkey;
   }

   public String getSecretkey() {
      return this.secretkey;
   }

   public String getIsLike() {
      return this.isLike;
   }

   public void setIsLike(String isLike) {
      this.isLike = isLike;
   }

   public String getKeepfirst() {
      return this.keepfirst;
   }

   public void setKeepfirst(String keepfirst) {
      this.keepfirst = keepfirst;
   }

   public String getEncdigit() {
      return this.encdigit;
   }

   public void setEncdigit(String encdigit) {
      this.encdigit = encdigit;
   }

   public String getTwoindex() {
      return this.twoindex;
   }

   public void setTwoindex(String twoindex) {
      this.twoindex = twoindex;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         Columninfo columninfo = (Columninfo)o;
         return Objects.equals(this.encryptiontype, columninfo.encryptiontype) && Objects.equals(this.secretkey, columninfo.secretkey) && Objects.equals(this.isLike, columninfo.isLike);
      } else {
         return false;
      }
   }

   public int hashCode() {
      return Objects.hash(this.encryptiontype, this.secretkey, this.isLike);
   }

   public Columninfo clone() {
      try {
         return (Columninfo)super.clone();
      } catch (CloneNotSupportedException e) {
         throw new RuntimeException("Cloning not supported", e);
      }
   }
}
