package test.hive;

import bean.Column;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import util.JdbcUtil;
import util.SqlUtil;

public class TestMysql {
   public static void main(String[] args) {
      conn();
      testMysql();
   }

   private static void conn() {
      String content = "{\n      \"ip_port\": \"127.0.0.1:43001\",\n      \"url\": \"jdbc:mysql://127.0.0.1:43001/database\",\n      \"username\": \"boyiming\",\n      \"password\": \"pdaesd\",\n      \"dbType\": \"mysql\",\n      \"isIgnorecase\":\"1\",\n    }";
      JdbcUtil.initData(content);
   }

   static void testMysql() {
      Map<String, String> params = new HashMap();
      String sql = "select *from test";
      params.put("sql", sql);
      params.put("dbType", "mysql");
      params.put("schema", "database");
      params.put("url", "jdbc:mysql://127.0.0.1:43001/database");
      SqlUtil sqlUtil = new SqlUtil();
      System.out.println(sql);
      System.out.println("---------------------/source sql    ------------------------------------------------");
      Map<String, Object> res = sqlUtil.parseSqlStructure(params);
      print(res);
   }

   public static void print(Map<String, Object> res) {
      System.out.println("\n\n====sql====");
      System.out.println(res.get("sql"));
      System.out.println("\n\n====sqlType====");
      System.out.println(res.get("type"));
      System.out.println("\n\n====schemaMap====");
      Map<String, Object> schemaMap = (Map)res.get("schemaMap");
      if (schemaMap != null && !schemaMap.isEmpty()) {
         for(Map.Entry<String, Object> item : schemaMap.entrySet()) {
            System.out.println((String)item.getKey() + "\t" + item.getValue());
         }
      }

      System.out.println("\n\n====tableMap====");
      Map<String, Object> tableMap = (Map)res.get("tableMap");
      if (tableMap != null && !tableMap.isEmpty()) {
         for(Map.Entry<String, Object> item : tableMap.entrySet()) {
            System.out.println((String)item.getKey() + "\t" + item.getValue());
         }
      }

      System.out.println("\n\n====columnList====");
      ArrayList<Column> columnList = (ArrayList)res.get("columnList");
      String[] var10000 = new String[]{"columnName", "columnAlisa", "fullName", "nowName", "dataType", "schema", "table", "value", "expr"};

      for(int i = 0; i < columnList.size(); ++i) {
         System.out.println(((Column)columnList.get(i)).getColumnName());
      }

      System.out.println("\n\n====whereList====");
      ArrayList<Map<String, Object>> whereList = (ArrayList)res.get("whereList");
      if (whereList != null && !whereList.isEmpty()) {
         for(Map<String, Object> where : whereList) {
            for(Map.Entry<String, Object> item : where.entrySet()) {
               System.out.println((String)item.getKey() + "\t" + item.getValue());
            }
         }
      }

   }
}
