package util;

import bean.DataBase;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import util.getdata.DataBaseGetData;

public class JdbcCacheUtil {
   public static List<DataBase> dataBaseList = new ArrayList();
   public static boolean init = false;

   public static void initData(String json) {
      DataBaseGetData dataBaseGetData = new DataBaseGetData(dataBaseList);
      dataBaseGetData.setJson(json);
      dataBaseGetData.cacheData();
   }

   public static void refreshData(String json) {
      DataBaseGetData dataBaseGetData = new DataBaseGetData(dataBaseList);
      dataBaseGetData.setJson(json);
      dataBaseGetData.refresh();
   }

   public static void initDataAsynchronous(String json) {
      DataBaseGetData dataBaseGetData = new DataBaseGetData(dataBaseList);
      dataBaseGetData.setJson(json);
      Thread thread = new Thread(dataBaseGetData);
      thread.start();
   }

   public static Connection getConnection(String url, String username, String password) {
      Connection connection = null;

      try {
         connection = DriverManager.getConnection(url, username, password);
      } catch (Exception throwables) {
         throwables.printStackTrace();
      }

      return connection;
   }

   public static Connection getGaussConnection(String url, String username, String password) {
      Connection connection = null;

      try {
         connection = DriverManager.getConnection(url, username, password);
      } catch (Exception throwables) {
         throwables.printStackTrace();
      }

      return connection;
   }

   public static Connection getDmConnection(String url, String username, String password) {
      Connection connection = null;

      try {
         String driver = "dm.jdbc.driver.DmDriver";
         Class.forName(driver);
         connection = DriverManager.getConnection(url, username, password);
      } catch (Exception throwables) {
         throwables.printStackTrace();
      }

      return connection;
   }

   public static void closeConnection(Connection connection) {
      if (connection != null) {
         try {
            connection.close();
         } catch (SQLException throwables) {
            throwables.printStackTrace();
         }
      }

   }

   public static void main(String[] args) {
   }
}
