package util.getdata;

import bean.Column;
import bean.DataBase;
import bean.Schema;
import bean.Synonym;
import bean.Table;
import bean.View;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import util.HBaseUtil;

public class CacheHbase extends CacheData {
   public CacheHbase(DataBase dataBase, CountDownLatch cdl) {
      super(dataBase, cdl);
   }

   public void run() {
      System.out.println("hbase开始缓存");
      DataBase dataBase = this.getDataBase();
      Connection connection = null;
      Statement statement = null;

      try {
         String ip_port = dataBase.getIp_port();
         String ip = ip_port.split(":")[0];
         String port = ip_port.split(":")[1];
         connection = HBaseUtil.getConnection(ip, port);
         Admin admin = connection.getAdmin();
         List<Schema> schemaList = this.getSchema(statement);
         dataBase.setSchemaList(schemaList);

         for(Schema schema : schemaList) {
            String schemaName = schema.getRealName();
            if (!dataBase.getExcludeSchema().contains(schemaName)) {
               List<Table> tableList = this.getTable(admin, schemaName);
               schema.setTableList(tableList);

               for(Table table : tableList) {
                  List<Column> columnList = this.getColumn(admin, table.getSchema(), table.getName());
                  table.setColumnList(columnList);
               }

               List<View> viewList = this.getView(statement, schemaName);
               schema.setViewList(viewList);
               List<Synonym> synonymList = this.getSynonym(statement, schemaName);
               schema.setSynonymList(synonymList);
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         try {
            HBaseUtil.closeConnection(connection);
            if (statement != null) {
               statement.close();
            }
         } catch (SQLException throwables) {
            throwables.printStackTrace();
         }

         this.getCdl().countDown();
         System.out.println("hbase结束缓存");
      }

   }

   public List<Schema> getSchema(Statement statement) throws SQLException {
      List<Schema> schemaList = new ArrayList();
      Schema common = new Schema("common");
      schemaList.add(common);
      return schemaList;
   }

   public List<Table> getTable(Statement statement, String schema) throws SQLException {
      List<Table> tableList = new ArrayList();
      return tableList;
   }

   public List<Table> getTable(Admin admin, String schema) throws Exception {
      List<Table> tableList = new ArrayList();
      TableName[] tableNames = admin.listTableNames();

      for(TableName tableName : tableNames) {
         tableList.add(new Table(tableName.getNameAsString(), schema));
      }

      return tableList;
   }

   public List<Column> getColumn(Statement statement, String schema, String table) throws SQLException {
      List<Column> columnList = new ArrayList();
      String sql = "select column_name,data_type from all_tab_columns where owner='" + schema + "' and Table_Name='" + table + "'";
      ResultSet resultSet = statement.executeQuery(sql);

      while(resultSet.next()) {
         columnList.add(new Column(resultSet.getString("COLUMN_NAME"), schema, table, resultSet.getString("DATA_TYPE")));
      }

      resultSet.close();
      return columnList;
   }

   public List<Column> getColumn(Admin admin, String schema, String table) throws Exception {
      List<Column> columnList = new ArrayList();
      HTableDescriptor tableDescriptor = admin.getTableDescriptor(TableName.valueOf(table));

      for(HColumnDescriptor family : tableDescriptor.getFamilies()) {
         columnList.add(new Column(new String(family.getName()), schema, table, "varchar"));
      }

      return columnList;
   }

   public List<View> getView(Statement statement, String schema) throws SQLException {
      List<View> views = new ArrayList();
      return views;
   }

   public List<Synonym> getSynonym(Statement statement, String schema) throws SQLException {
      List<Synonym> synonyms = new ArrayList();
      return synonyms;
   }
}
