package util.sqlparse.visitor.es.memo;

import org.antlr.v4.runtime.tree.ParseTree;
import util.sqlparse.visitor.common.Objects;
import util.sqlparse.visitor.common.scope.Scope;

public class MappingMemo extends Reference {
   public Scope scope;
   public IndexMemo index;

   public MappingMemo() {
   }

   public MappingMemo(ParseTree x) {
      this();
      this.ref = x;
   }

   public String getQualifiedName() {
      return this.name;
   }

   public String getUniqueName() {
      return this.scope.id + ":" + this.getQualifiedName();
   }

   public String getFullName() {
      return this.index == null ? this.name : String.format("%s.%s", this.index.name, this.name);
   }

   public String toString() {
      return this.name;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         MappingMemo mappingMemo = (MappingMemo)o;
         if ((this.ref != null || mappingMemo.ref == null) && (this.ref == null || mappingMemo.ref != null)) {
            if (this.ref != null && !this.ref.equals(mappingMemo.ref)) {
               return false;
            } else if ((this.index != null || mappingMemo.index == null) && (mappingMemo.index != null || this.index == null)) {
               return this.index != null && !this.index.equals(mappingMemo.index) ? false : Objects.equals(this.name, mappingMemo.name);
            } else {
               return false;
            }
         } else {
            return false;
         }
      } else {
         return false;
      }
   }

   public int hashCode() {
      int result = this.ref == null ? 0 : this.ref.hashCode();
      result = 31 * result + this.name.hashCode();
      if (this.index != null) {
         result = 31 * result + this.index.hashCode();
      }

      return result;
   }

   public String flatFullName() {
      StringBuilder s = new StringBuilder();
      if (this.index != null) {
         s.append(this.index.name);
         s.append(".");
      }

      s.append(this.name);
      return s.toString();
   }
}
