package util.sqlparse.visitor.greenplum.test;

import bean.Column;
import bean.DataBase;
import bean.Schema;
import bean.Table;
import bean.View;
import java.io.IOException;
import java.util.ArrayList;
import test.StopWatch;
import util.sqlparse.visitor.common.bean.SQLResult;
import util.sqlparse.visitor.common.memo.FieldMemo;
import util.sqlparse.visitor.oracle.SQLParser;

public class SQLParseTest1 {
   public static void main(String[] args) {
      testSelect();
   }

   static DataBase createDB() {
      DataBase db = new DataBase();
      db.setSchemaList(new ArrayList());
      Schema schema = new Schema("test");
      schema.setViewList(new ArrayList());
      View view = new View(" vtest", " create or replace view vtest  as with a as (select login_name as lname,dept_id as did from vtest1) select b.dept_id as did,b.dept_name as dept_name, a.lname as account from a left join sys_dept b on a.did=b.dept_id");
      View view1 = new View(" vtest1", " create or replace view vtest1 as select a.user_id,a.user_name,a.login_name,a.dept_id from sys_user a");
      schema.getViewList().add(view);
      schema.getViewList().add(view1);
      db.getSchemaList().add(schema);
      Table table = new Table(" sys_user", "test");
      table.setColumnList(new ArrayList());
      table.getColumnList().add(new Column(" user_id", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" user_name", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" login_name", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" dept_id", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" user_type", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" email", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" sex", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" avatar", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" password", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" salt", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" status", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" del_flag", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" login_ip", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" login_date", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" pwd_update_date", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" create_by", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" create_time", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" update_by", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" update_time", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" phonenumber", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" remark", (String)null, false, (String)null));
      schema.getTableList().add(table);
      table = new Table(" sys_dept", "test");
      table.setColumnList(new ArrayList());
      table.getColumnList().add(new Column(" dept_id", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" parent_id", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" ancestors", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" dept_name", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" order_num", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" leader", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" status", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" del_flag", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" create_by", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" create_time", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" update_by", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" update_time", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" phone", (String)null, false, (String)null));
      table.getColumnList().add(new Column(" email", (String)null, false, (String)null));
      schema.getTableList().add(table);
      table = new Table(" hr_info", "test");
      table.setColumnList(new ArrayList());
      String tableName = " HR_INFO";
      String schemaName = " TEST";
      table.getColumnList().add(new Column(" department_id", schemaName, tableName, (String)null));
      table.getColumnList().add(new Column(" location_id", schemaName, tableName, (String)null));
      table.getColumnList().add(new Column(" manager_id", schemaName, tableName, (String)null));
      table.getColumnList().add(new Column(" people", schemaName, tableName, (String)null));
      table.getColumnList().add(new Column(" last_name", schemaName, tableName, " people"));
      table.getColumnList().add(new Column(" department_id", schemaName, tableName, " people"));
      table.getColumnList().add(new Column(" salary", schemaName, tableName, " people"));
      schema.getTableList().add(table);
      table = new Table("tb1", "test");
      table.setColumnList(new ArrayList());
      table.getColumnList().add(new Column("c1", (String)null, false, (String)null));
      table.getColumnList().add(new Column("c2", (String)null, false, (String)null));
      table.getColumnList().add(new Column("c3", (String)null, false, (String)null));
      table.getColumnList().add(new Column("name", (String)null, false, (String)null));
      schema.getTableList().add(table);
      table = new Table("tb2", "test");
      table.setColumnList(new ArrayList());
      table.getColumnList().add(new Column("c1", (String)null, false, (String)null));
      table.getColumnList().add(new Column("c2", (String)null, false, (String)null));
      table.getColumnList().add(new Column("c4", (String)null, false, (String)null));
      table.getColumnList().add(new Column("name", (String)null, false, (String)null));
      schema.getTableList().add(table);
      table = new Table("tb4", "test");
      table.setColumnList(new ArrayList());
      table.getColumnList().add(new Column("c2", (String)null, false, (String)null));
      table.getColumnList().add(new Column("c3", (String)null, false, (String)null));
      table.getColumnList().add(new Column("c4", (String)null, false, (String)null));
      table.getColumnList().add(new Column("name", (String)null, false, (String)null));
      schema.getTableList().add(table);
      table = new Table("tb5", "test");
      table.setColumnList(new ArrayList());
      table.getColumnList().add(new Column("c1", (String)null, false, (String)null));
      table.getColumnList().add(new Column("c2", (String)null, false, (String)null));
      table.getColumnList().add(new Column("c3", (String)null, false, (String)null));
      table.getColumnList().add(new Column("name", (String)null, false, (String)null));
      schema.getTableList().add(table);
      return db;
   }

   static void testSelect() {
      StopWatch sw = new StopWatch();
      String[] sqls = new String[]{"CREATE OR REPLACE TRIGGER TRIG_EAF_01 BEFORE DDL ON DATABASE\nDECLARE\nN\tNUMBER;\nSTR_STMT VARCHAR;\nSQL_TEXT DM_NAME_LIST_T; \nBEGIN\nSET TIME ZONE LOCAL;\nEND;"};

      for(int i1 = 0; i1 < sqls.length; ++i1) {
         String sql = sqls[i1];
         System.out.println(" [" + i1 + " ]*****************************************************");
         System.out.println(sql);
         sw.begin();

         try {
            SQLParser parser = new SQLParser();
            SQLResult result = parser.parse(sql, createDB(), " test");
            sw.end();
            sw.print();
            assertResult(result);
         } catch (Exception e) {
            System.out.println(sql);
            e.printStackTrace();
         }

         try {
            System.in.read();
         } catch (IOException e) {
            e.printStackTrace();
         }
      }

      sw.printAvg();
   }

   static String getString(FieldMemo memo) {
      StringBuffer s = new StringBuffer();
      s.append(memo.getAtomName());
      if (memo.children.size() > 0) {
         s.append("  [ ");
         if (memo.children != null) {
            for(FieldMemo child : memo.children) {
               s.append(getString(child));
               s.append(" ,");
            }

            s.deleteCharAt(s.length() - 1);
         }

         s.append("  ] ");
      }

      return s.toString();
   }

   static void assertResult(SQLResult result) {
      System.out.println("------------------[TABLES-INFO]----------------");
      System.out.println(result.statement.toString());
   }
}
