package util.sqlparse.visitor.mongo;

import org.bson.BsonJavaScript;
import org.bson.BsonValue;

public class BsonJsNode extends BsonNode {
   private BsonJavaScript value;

   public BsonJsNode() {
   }

   public BsonJavaScript getValue() {
      return this.value;
   }

   public void setValue(BsonJavaScript value) {
      this.value = value;
   }

   public BsonJsNode(String name, BsonJavaScript js) {
      super(name);
      this.value = js;
   }

   public Object value() {
      return this.value;
   }

   public void value(Object raw, Object... other) {
      if (raw instanceof BsonJavaScript) {
         this.value = (BsonJavaScript)raw;
      }

   }

   public BsonValue data() {
      return this.value;
   }

   public BsonNodeType type() {
      return BsonNodeType.Javascript;
   }

   public BsonJsNode clone() {
      BsonJavaScript value = new BsonJavaScript(this.value.getCode());
      return new BsonJsNode((String)null, value);
   }
}
