package util.sqlparse.visitor.mongo;

import org.bson.BsonDocument;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonValue;

public class BsonJsScopeNode extends BsonNode {
   private BsonJavaScriptWithScope value;

   public BsonJsScopeNode() {
   }

   public BsonJavaScriptWithScope getValue() {
      return this.value;
   }

   public void setValue(BsonJavaScriptWithScope value) {
      this.value = value;
   }

   public BsonJsScopeNode(String name, BsonJavaScriptWithScope js) {
      super(name);
      this.value = js;
   }

   public Object value() {
      return this.value;
   }

   public void value(Object raw, Object... other) {
      if (raw instanceof BsonJavaScriptWithScope) {
         this.value = (BsonJavaScriptWithScope)raw;
      }

   }

   public BsonValue data() {
      return this.value;
   }

   public BsonNodeType type() {
      return BsonNodeType.JavaScriptWithNode;
   }

   public BsonJsScopeNode clone() {
      String code = this.value.getCode();
      BsonDocument scope = this.value.getScope();
      BsonDocument doc = scope == null ? null : scope.clone();
      BsonJavaScriptWithScope value = new BsonJavaScriptWithScope(code, doc);
      return new BsonJsScopeNode((String)null, value);
   }
}
