package com.alibaba.druid.proxy.jdbc;

import java.math.BigDecimal;
import java.util.Calendar;

public final class JdbcParameterDecimal implements JdbcParameter {
   private final BigDecimal value;
   public static JdbcParameterDecimal NULL = new JdbcParameterDecimal((BigDecimal)null);
   public static JdbcParameterDecimal ZERO;
   public static JdbcParameterDecimal TEN;

   private JdbcParameterDecimal(BigDecimal value) {
      this.value = value;
   }

   public static JdbcParameterDecimal valueOf(BigDecimal x) {
      if (x == null) {
         return NULL;
      } else if (0 == x.compareTo(BigDecimal.ZERO)) {
         return ZERO;
      } else {
         return 0 == x.compareTo(BigDecimal.TEN) ? TEN : new JdbcParameterDecimal(x);
      }
   }

   public Object getValue() {
      return this.value;
   }

   public long getLength() {
      return 0L;
   }

   public Calendar getCalendar() {
      return null;
   }

   public int getSqlType() {
      return 3;
   }

   static {
      ZERO = new JdbcParameterDecimal(BigDecimal.ZERO);
      TEN = new JdbcParameterDecimal(BigDecimal.TEN);
   }
}
