package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class SQLBetweenExpr extends SQLExprImpl implements SQLReplaceable, Serializable {
   private static final long serialVersionUID = 1L;
   public SQLExpr testExpr;
   private boolean not;
   public SQLExpr beginExpr;
   public SQLExpr endExpr;

   public SQLBetweenExpr() {
   }

   public SQLBetweenExpr clone() {
      SQLBetweenExpr x = new SQLBetweenExpr();
      if (this.testExpr != null) {
         x.setTestExpr(this.testExpr.clone());
      }

      x.not = this.not;
      if (this.beginExpr != null) {
         x.setBeginExpr(this.beginExpr.clone());
      }

      if (this.endExpr != null) {
         x.setEndExpr(this.endExpr.clone());
      }

      return x;
   }

   public SQLBetweenExpr(SQLExpr testExpr, SQLExpr beginExpr, SQLExpr endExpr) {
      this.setTestExpr(testExpr);
      this.setBeginExpr(beginExpr);
      this.setEndExpr(endExpr);
   }

   public SQLBetweenExpr(SQLExpr testExpr, boolean not, SQLExpr beginExpr, SQLExpr endExpr) {
      this(testExpr, beginExpr, endExpr);
      this.not = not;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         if (this.testExpr != null) {
            this.testExpr.accept(visitor);
         }

         if (this.beginExpr != null) {
            this.beginExpr.accept(visitor);
         }

         if (this.endExpr != null) {
            this.endExpr.accept(visitor);
         }
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      return Arrays.asList(this.testExpr, this.beginExpr, this.endExpr);
   }

   public SQLExpr getTestExpr() {
      return this.testExpr;
   }

   public void setTestExpr(SQLExpr testExpr) {
      if (testExpr != null) {
         testExpr.setParent(this);
      }

      this.testExpr = testExpr;
   }

   public boolean isNot() {
      return this.not;
   }

   public void setNot(boolean not) {
      this.not = not;
   }

   public SQLExpr getBeginExpr() {
      return this.beginExpr;
   }

   public void setBeginExpr(SQLExpr beginExpr) {
      if (beginExpr != null) {
         beginExpr.setParent(this);
      }

      this.beginExpr = beginExpr;
   }

   public SQLExpr getEndExpr() {
      return this.endExpr;
   }

   public void setEndExpr(SQLExpr endExpr) {
      if (endExpr != null) {
         endExpr.setParent(this);
      }

      this.endExpr = endExpr;
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.beginExpr == null ? 0 : this.beginExpr.hashCode());
      result = 31 * result + (this.endExpr == null ? 0 : this.endExpr.hashCode());
      result = 31 * result + (this.not ? 1231 : 1237);
      result = 31 * result + (this.testExpr == null ? 0 : this.testExpr.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         SQLBetweenExpr other = (SQLBetweenExpr)obj;
         if (this.beginExpr == null) {
            if (other.beginExpr != null) {
               return false;
            }
         } else if (!this.beginExpr.equals(other.beginExpr)) {
            return false;
         }

         if (this.endExpr == null) {
            if (other.endExpr != null) {
               return false;
            }
         } else if (!this.endExpr.equals(other.endExpr)) {
            return false;
         }

         if (this.not != other.not) {
            return false;
         } else {
            if (this.testExpr == null) {
               if (other.testExpr != null) {
                  return false;
               }
            } else if (!this.testExpr.equals(other.testExpr)) {
               return false;
            }

            return true;
         }
      }
   }

   public SQLDataType computeDataType() {
      return SQLBooleanExpr.DATA_TYPE;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (expr == this.testExpr) {
         this.setTestExpr(target);
         return true;
      } else if (expr == this.beginExpr) {
         this.setBeginExpr(target);
         return true;
      } else if (expr == this.endExpr) {
         this.setEndExpr(target);
         return true;
      } else {
         return false;
      }
   }
}
