package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class SQLExtractExpr extends SQLExprImpl implements SQLReplaceable {
   private SQLExpr value;
   private SQLIntervalUnit unit;

   public SQLExtractExpr clone() {
      SQLExtractExpr x = new SQLExtractExpr();
      if (this.value != null) {
         x.setValue(this.value.clone());
      }

      x.unit = this.unit;
      return x;
   }

   public SQLExpr getValue() {
      return this.value;
   }

   public void setValue(SQLExpr value) {
      if (value != null) {
         value.setParent(this);
      }

      this.value = value;
   }

   public SQLIntervalUnit getUnit() {
      return this.unit;
   }

   public void setUnit(SQLIntervalUnit unit) {
      this.unit = unit;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this) && this.value != null) {
         this.value.accept(visitor);
      }

      visitor.endVisit(this);
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.value == expr) {
         this.setValue(target);
         return true;
      } else {
         return false;
      }
   }

   public List getChildren() {
      return Collections.singletonList(this.value);
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
      result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (!(obj instanceof SQLExtractExpr)) {
         return false;
      } else {
         SQLExtractExpr other = (SQLExtractExpr)obj;
         if (this.unit != other.unit) {
            return false;
         } else {
            if (this.value == null) {
               if (other.value != null) {
                  return false;
               }
            } else if (!this.value.equals(other.value)) {
               return false;
            }

            return true;
         }
      }
   }

   public SQLDataType computeDataType() {
      return SQLIntegerExpr.DATA_TYPE;
   }
}
