package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLAlterTablePartitionSetProperties extends SQLObjectImpl implements SQLAlterTableItem {
   private final List<SQLAssignItem> partition = new ArrayList(4);
   private final List<SQLAssignItem> partitionProperties = new ArrayList(4);

   public List<SQLAssignItem> getPartitionProperties() {
      return this.partitionProperties;
   }

   public List<SQLAssignItem> getPartition() {
      return this.partition;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.partition);
         this.acceptChild(visitor, this.partitionProperties);
      }

      visitor.endVisit(this);
   }
}
