package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLDropServerStatement extends SQLStatementImpl implements SQLDropStatement, SQLReplaceable {
   private SQLExpr name;
   private boolean ifExists;

   public SQLDropServerStatement() {
   }

   public SQLDropServerStatement(DbType dbType) {
      super(dbType);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
      }

      visitor.endVisit(this);
   }

   public SQLExpr getName() {
      return this.name;
   }

   public void setName(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.name = x;
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.name != null) {
         children.add(this.name);
      }

      return children;
   }

   public boolean isIfExists() {
      return this.ifExists;
   }

   public void setIfExists(boolean ifExists) {
      this.ifExists = ifExists;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      if (this.name == expr) {
         this.setName((SQLName)target);
         return true;
      } else {
         return false;
      }
   }
}
