package com.alibaba.druid.sql.dialect.db2.ast.expr.constraint;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLColumnConstraint;
import com.alibaba.druid.sql.ast.statement.SQLConstraintImpl;
import com.alibaba.druid.sql.dialect.db2.ast.DB2SQLObject;
import com.alibaba.druid.sql.dialect.db2.ast.DB2SQLObjectImpl;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class DB2Constraint extends SQLConstraintImpl implements DB2SQLObject, SQLColumnConstraint {
   private Boolean iNull;
   private Boolean notNull;
   private DB2ConstraintCheck check;
   private SQLExpr defValue;
   private DB2Unique unique;
   private DB2PrimaryKey primaryKey;
   private DB2Reference reference;
   private ConstraintType type;

   public void simplify() {
   }

   public Boolean getiNull() {
      return this.iNull;
   }

   public void setiNull(Boolean iNull) {
      this.iNull = iNull;
   }

   public Boolean getNotNull() {
      return this.notNull;
   }

   public void setNotNull(Boolean notNull) {
      this.notNull = notNull;
   }

   public DB2ConstraintCheck getCheck() {
      return this.check;
   }

   public void setCheck(DB2ConstraintCheck check) {
      this.check = check;
      check.setParent(this);
   }

   public SQLExpr getDefValue() {
      return this.defValue;
   }

   public void setDefValue(SQLExpr defValue) {
      this.defValue = defValue;
      defValue.setParent(this);
   }

   public DB2Unique getUnique() {
      return this.unique;
   }

   public void setUnique(DB2Unique unique) {
      this.unique = unique;
      unique.setParent(this);
   }

   public DB2PrimaryKey getPrimaryKey() {
      return this.primaryKey;
   }

   public void setPrimaryKey(DB2PrimaryKey primaryKey) {
      this.primaryKey = primaryKey;
      primaryKey.setParent(this);
   }

   public DB2Reference getReference() {
      return this.reference;
   }

   public void setReference(DB2Reference reference) {
      this.reference = reference;
      reference.setParent(this);
   }

   public ConstraintType getType() {
      return this.type;
   }

   public void setType(ConstraintType type) {
      this.type = type;
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((DB2ASTVisitor)visitor);
   }

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
      }

      visitor.endVisit(this);
   }

   public DB2Constraint clone() {
      DB2Constraint c = new DB2Constraint();
      c.setName(this.name.clone());
      c.iNull = this.iNull;
      c.notNull = this.notNull;
      if (this.check != null) {
         c.setCheck(this.check.clone());
      }

      if (this.defValue != null) {
         c.setDefValue(this.defValue.clone());
      }

      if (this.unique != null) {
         c.setUnique(this.unique.clone());
      }

      if (this.primaryKey != null) {
         c.setPrimaryKey(this.primaryKey.clone());
      }

      if (this.reference != null) {
         c.setReference(this.reference.clone());
      }

      c.type = this.type;
      return c;
   }

   public static class DB2ConstraintCheck extends DB2SQLObjectImpl {
      SQLExpr expr;
      boolean noInherit;

      public SQLExpr getExpr() {
         return this.expr;
      }

      public void setExpr(SQLExpr expr) {
         this.expr = expr;
      }

      public boolean isNoInherit() {
         return this.noInherit;
      }

      public void setNoInherit(boolean noInherit) {
         this.noInherit = noInherit;
      }

      public void accept0(SQLASTVisitor visitor) {
         this.accept0((DB2ASTVisitor)visitor);
      }

      public void accept0(DB2ASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.expr);
         }

         visitor.endVisit(this);
      }

      public DB2ConstraintCheck clone() {
         DB2ConstraintCheck c = new DB2ConstraintCheck();
         c.setExpr(this.expr.clone());
         c.noInherit = this.noInherit;
         return c;
      }
   }

   public static class DB2IndexParamaters extends DB2SQLObjectImpl {
      private List<DB2StorageParameter> parameters = new ArrayList();
      private SQLExpr tablespace;

      public SQLExpr getTablespace() {
         return this.tablespace;
      }

      public void setTablespace(SQLExpr tablespace) {
         this.tablespace = tablespace;
      }

      public List<DB2StorageParameter> getParameters() {
         return this.parameters;
      }

      public void setParameters(List<DB2StorageParameter> parameters) {
         this.parameters = parameters;
      }

      public void addParameter(DB2StorageParameter parameter) {
         this.parameters.add(parameter);
         parameter.setParent(this);
      }

      public void accept0(SQLASTVisitor visitor) {
         this.accept0((DB2ASTVisitor)visitor);
      }

      public void accept0(DB2ASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.parameters);
            this.acceptChild(visitor, this.tablespace);
         }

         visitor.endVisit(this);
      }

      public DB2IndexParamaters clone() {
         DB2IndexParamaters c = new DB2IndexParamaters();
         if (this.parameters != null && this.parameters.size() > 0) {
            for(DB2StorageParameter parameter : this.parameters) {
               c.addParameter(parameter.clone());
            }
         }

         if (this.tablespace != null) {
            c.setTablespace(this.tablespace.clone());
         }

         return c;
      }
   }

   public static class DB2Unique extends DB2SQLObjectImpl {
      protected List<SQLName> columns = new ArrayList();
      protected DB2IndexParamaters indexParamaters;

      public List<SQLName> getColumns() {
         return this.columns;
      }

      public void setColumns(List<SQLName> columns) {
         this.columns = columns;
      }

      public DB2IndexParamaters getIndexParamaters() {
         return this.indexParamaters;
      }

      public void setIndexParamaters(DB2IndexParamaters indexParamaters) {
         this.indexParamaters = indexParamaters;
      }

      public void addColumn(SQLName column) {
         this.columns.add(column);
         column.setParent(this);
      }

      public void accept0(SQLASTVisitor visitor) {
         this.accept0((DB2ASTVisitor)visitor);
      }

      public void accept0(DB2ASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.columns);
            this.acceptChild(visitor, this.indexParamaters);
         }

         visitor.endVisit(this);
      }

      public DB2Unique clone() {
         DB2Unique c = new DB2Unique();
         if (this.columns != null && this.columns.size() > 0) {
            for(SQLName column : this.columns) {
               c.addColumn(column);
            }
         }

         if (this.indexParamaters != null) {
            c.setIndexParamaters(this.indexParamaters.clone());
         }

         return c;
      }
   }

   public static class DB2PrimaryKey extends DB2Unique {
      public DB2PrimaryKey clone() {
         DB2PrimaryKey c = new DB2PrimaryKey();
         if (this.columns != null && this.columns.size() > 0) {
            for(SQLName column : this.columns) {
               c.addColumn(column);
            }
         }

         if (this.indexParamaters != null) {
            c.setIndexParamaters(this.indexParamaters.clone());
         }

         return c;
      }
   }

   public static class DB2ForeignKey extends DB2SQLObjectImpl {
      private List<SQLName> columns = new ArrayList();
      protected DB2Reference reference;

      public DB2Reference getReference() {
         return this.reference;
      }

      public void setReference(DB2Reference reference) {
         this.reference = reference;
      }

      public List<SQLName> getColumns() {
         return this.columns;
      }

      public void setColumns(List<SQLName> columns) {
         this.columns = columns;
      }

      public void addColumn(SQLName column) {
         this.columns.add(column);
         column.setParent(this);
      }

      public void accept0(SQLASTVisitor visitor) {
         this.accept0((DB2ASTVisitor)visitor);
      }

      public void accept0(DB2ASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.columns);
            this.acceptChild(visitor, this.reference);
         }

         visitor.endVisit(this);
      }

      public DB2ForeignKey clone() {
         DB2ForeignKey c = new DB2ForeignKey();
         if (this.columns != null && this.columns.size() > 0) {
            for(SQLName column : this.columns) {
               c.addColumn(column);
            }
         }

         if (this.reference != null) {
            c.setReference(this.reference.clone());
         }

         return c;
      }
   }

   public static class DB2Reference extends DB2SQLObjectImpl {
      private SQLExpr refTable;
      private List<SQLExpr> columns = new ArrayList();
      private MatchType matchType;
      private KeyAction deleteAction;
      private KeyAction updateAction;

      public SQLExpr getRefTable() {
         return this.refTable;
      }

      public void setRefTable(SQLExpr refTable) {
         this.refTable = refTable;
         refTable.setParent(this);
      }

      public void addColumn(SQLExpr column) {
         this.columns.add(column);
         column.setParent(this);
      }

      public List<SQLExpr> getColumns() {
         return this.columns;
      }

      public void setColumns(List<SQLExpr> columns) {
         this.columns = columns;
      }

      public MatchType getMatchType() {
         return this.matchType;
      }

      public void setMatchType(MatchType matchType) {
         this.matchType = matchType;
      }

      public KeyAction getDeleteAction() {
         return this.deleteAction;
      }

      public void setDeleteAction(KeyAction deleteAction) {
         this.deleteAction = deleteAction;
      }

      public KeyAction getUpdateAction() {
         return this.updateAction;
      }

      public void setUpdateAction(KeyAction updateAction) {
         this.updateAction = updateAction;
      }

      public void accept0(SQLASTVisitor visitor) {
         this.accept0((DB2ASTVisitor)visitor);
      }

      public void accept0(DB2ASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.refTable);
            this.acceptChild(visitor, this.columns);
         }

         visitor.endVisit(this);
      }

      public DB2Reference clone() {
         DB2Reference c = new DB2Reference();
         c.setRefTable(this.refTable.clone());
         if (this.columns != null && this.columns.size() > 0) {
            for(SQLExpr column : this.columns) {
               c.addColumn(column.clone());
            }
         }

         c.matchType = this.matchType;
         c.deleteAction = this.deleteAction;
         c.updateAction = this.updateAction;
         return c;
      }

      public static enum MatchType {
         full,
         partial,
         simple;
      }

      public static enum KeyAction {
         onDelete,
         onUpdate,
         noAction,
         restrict,
         cascade,
         setNull,
         setDefault;
      }
   }

   public static enum ConstraintType {
      deferrable,
      notDeferrable,
      initiallyDeferred,
      initiallyImmediate;
   }
}
