package com.alibaba.druid.sql.dialect.db2.ast.expr.tablesource;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.dialect.db2.ast.DB2SQLObject;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;

public class DB2ExprTableSource extends SQLExprTableSource implements DB2SQLObject, DB2TableSource {
   protected boolean only;

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this)) {
         if (this.expr != null) {
            this.expr.accept(visitor);
         }

         if (this.sampling != null) {
            this.sampling.accept(visitor);
         }
      }

      visitor.endVisit(this);
   }

   public void addColumnAlias(SQLName name) {
      if (this.columns == null) {
         this.columns = new ArrayList();
      }

      this.columns.add(name);
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((DB2ASTVisitor)visitor);
   }

   public boolean isOnly() {
      return this.only;
   }

   public void setOnly(boolean only) {
      this.only = only;
   }

   public DB2ExprTableSource clone() {
      DB2ExprTableSource x = new DB2ExprTableSource();
      this.cloneTo(x);
      x.only = this.only;
      return x;
   }
}
