package com.alibaba.druid.sql.dialect.db2.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.statement.SQLAlterStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class DB2AlterTableStatement extends SQLAlterTableStatement implements DB2SQLStatement, SQLAlterStatement {
   private boolean privileges = false;
   private boolean only = false;
   private boolean allInTableSpace = false;
   private boolean modify = false;

   public boolean isPrivileges() {
      return this.privileges;
   }

   public void setPrivileges(boolean privileges) {
      this.privileges = privileges;
   }

   public boolean isModify() {
      return this.modify;
   }

   public void setModify(boolean modify) {
      this.modify = modify;
   }

   public boolean isAllInTableSpace() {
      return this.allInTableSpace;
   }

   public void setAllInTableSpace(boolean allInTableSpace) {
      this.allInTableSpace = allInTableSpace;
   }

   public boolean isOnly() {
      return this.only;
   }

   public void setOnly(boolean only) {
      this.only = only;
   }

   public DB2AlterTableStatement() {
      this.dbType = DbType.db2;
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((DB2ASTVisitor)visitor);
   }

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.getTableSource());
         this.acceptChild(visitor, this.getItems());
      }

      visitor.endVisit(this);
   }
}
