package com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.dialect.db2.ast.DB2SQLObjectImpl;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2ASTVisitor;

public class DB2AlterTableDropColumn extends DB2SQLObjectImpl implements SQLAlterTableItem {
   private SQLExpr columnName;
   private DropColumType type;
   private boolean ifExists;

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.columnName);
      }

      visitor.endVisit(this);
   }

   public boolean isIfExists() {
      return this.ifExists;
   }

   public void setIfExists(boolean ifExists) {
      this.ifExists = ifExists;
   }

   public DropColumType getType() {
      return this.type;
   }

   public void setType(DropColumType type) {
      this.type = type;
   }

   public SQLExpr getColumnName() {
      return this.columnName;
   }

   public void setColumnName(SQLExpr columnName) {
      columnName.setParent(this);
      this.columnName = columnName;
   }

   public DB2AlterTableDropColumn clone() {
      DB2AlterTableDropColumn c = new DB2AlterTableDropColumn();
      c.setColumnName(this.columnName.clone());
      c.ifExists = this.ifExists;
      c.type = this.type;
      return c;
   }

   public static enum DropColumType {
      restrict,
      cascade;
   }
}
