package com.alibaba.druid.sql.dialect.gauss.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.statement.SQLAlterStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.dialect.gauss.visitor.GaussASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class GaussAlterTableStatement extends SQLAlterTableStatement implements GaussSQLStatement, SQLAlterStatement {
   private boolean only = false;
   private boolean allInTableSpace = false;
   private boolean modify = false;

   public boolean isModify() {
      return this.modify;
   }

   public void setModify(boolean modify) {
      this.modify = modify;
   }

   public boolean isAllInTableSpace() {
      return this.allInTableSpace;
   }

   public void setAllInTableSpace(boolean allInTableSpace) {
      this.allInTableSpace = allInTableSpace;
   }

   public boolean isOnly() {
      return this.only;
   }

   public void setOnly(boolean only) {
      this.only = only;
   }

   public GaussAlterTableStatement() {
      this.dbType = DbType.gauss;
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((GaussASTVisitor)visitor);
   }

   public void accept0(GaussASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.getTableSource());
         this.acceptChild(visitor, this.getItems());
      }

      visitor.endVisit(this);
   }
}
