package com.alibaba.druid.sql.dialect.gauss.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.statement.SQLRevokeStatement;
import com.alibaba.druid.sql.dialect.gauss.ast.GaussSQLObject;
import com.alibaba.druid.sql.dialect.gauss.ast.expr.GaussSQLObjectCollection;
import com.alibaba.druid.sql.dialect.gauss.visitor.GaussASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

import java.util.List;

public class GaussRevokeStatement extends SQLRevokeStatement implements GaussSQLObject {
   private boolean grantOptionFor;
   private SQLName roleName;
   GaussSQLObjectCollection groups = new GaussSQLObjectCollection();

   public SQLName getRoleName() {
      return this.roleName;
   }

   public void setRoleName(SQLName roleName) {
      this.roleName = roleName;
   }

   public GaussRevokeStatement() {
      this.dbType = DbType.gauss;
   }

   public void addGroup(SQLObject o) {
      this.groups.add(o);
      o.setParent(this);
   }

   public GaussSQLObjectCollection getGroups() {
      return this.groups;
   }

   public void setGroups(GaussSQLObjectCollection groups) {
      this.groups = groups;
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((GaussASTVisitor)visitor);
   }

   public void accept0(GaussASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.privileges);
         this.acceptChild(visitor, this.resource);
         this.acceptChild(visitor, this.users);
         this.acceptChild(visitor, (List<SQLObject>)this.groups);
         if (this.groups != null && this.groups.size() > 0) {
            for(SQLObject group : this.groups) {
               this.acceptChild(visitor, group);
            }
         }
      }

      visitor.endVisit(this);
   }

   public boolean isGrantOptionFor() {
      return this.grantOptionFor;
   }

   public void setGrantOptionFor(boolean grantOptionFor) {
      this.grantOptionFor = grantOptionFor;
   }
}
