package com.alibaba.druid.sql.dialect.greenplum.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.statement.SQLGrantStatement;
import com.alibaba.druid.sql.dialect.greenplum.ast.GPSQLObject;
import com.alibaba.druid.sql.dialect.greenplum.ast.expr.GPSQLObjectCollection;
import com.alibaba.druid.sql.dialect.greenplum.visitor.GPASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

import java.util.List;

public class GPGrantStatement extends SQLGrantStatement implements GPSQLObject {
   GPSQLObjectCollection groups = new GPSQLObjectCollection();

   public GPGrantStatement() {
      this.dbType = DbType.greenplum;
   }

   public void addGroup(SQLObject o) {
      this.groups.add(o);
      o.setParent(this);
   }

   public GPSQLObjectCollection getGroups() {
      return this.groups;
   }

   public void setGroups(GPSQLObjectCollection groups) {
      this.groups = groups;
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((GPASTVisitor)visitor);
   }

   public void accept0(GPASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.privileges);
         this.acceptChild(visitor, this.resource);
         this.acceptChild(visitor, this.users);
         this.acceptChild(visitor, (List<SQLObject>)this.groups);
         if (this.groups != null && this.groups.size() > 0) {
            for(SQLObject group : this.groups) {
               this.acceptChild(visitor, group);
            }
         }
      }

      visitor.endVisit(this);
   }
}
