package com.alibaba.druid.sql.dialect.mariadb.ast.expr;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;
import com.alibaba.druid.util.FnvHash;
import java.util.Collections;
import java.util.List;

public class MariadbUserName extends MariadbExprImpl implements SQLName, Cloneable {
   private String userName;
   private String host;
   private String identifiedBy;
   private long userNameHashCod64;
   private long hashCode64;

   public String getUserName() {
      return this.userName;
   }

   public void setUserName(String userName) {
      this.userName = userName;
      this.hashCode64 = 0L;
      this.userNameHashCod64 = 0L;
   }

   public String getNormalizeUserName() {
      return SQLUtils.normalize(this.userName);
   }

   public String getHost() {
      return this.host;
   }

   public void setHost(String host) {
      this.host = host;
      this.hashCode64 = 0L;
      this.userNameHashCod64 = 0L;
   }

   public void accept0(MariadbASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public String getSimpleName() {
      StringBuilder buf = new StringBuilder();
      if (this.userName.length() != 0 && this.userName.charAt(0) == '\'') {
         buf.append(this.userName);
      } else {
         buf.append('\'');
         buf.append(this.userName);
         buf.append('\'');
      }

      buf.append('@');
      if (this.host.length() != 0 && this.host.charAt(0) == '\'') {
         buf.append(this.host);
      } else {
         buf.append('\'');
         buf.append(this.host);
         buf.append('\'');
      }

      if (this.identifiedBy != null) {
         buf.append(" identifiedBy by ");
         buf.append(this.identifiedBy);
      }

      return buf.toString();
   }

   public String getIdentifiedBy() {
      return this.identifiedBy;
   }

   public void setIdentifiedBy(String identifiedBy) {
      this.identifiedBy = identifiedBy;
   }

   public String toString() {
      return this.getSimpleName();
   }

   public MariadbUserName clone() {
      MariadbUserName x = new MariadbUserName();
      x.userName = this.userName;
      x.host = this.host;
      x.identifiedBy = this.identifiedBy;
      x.hashCode64 = this.hashCode64;
      x.userNameHashCod64 = this.userNameHashCod64;
      return x;
   }

   public List<SQLObject> getChildren() {
      return Collections.emptyList();
   }

   public long nameHashCode64() {
      if (this.userNameHashCod64 == 0L && this.userName != null) {
         this.userNameHashCod64 = FnvHash.hashCode64(this.userName);
      }

      return this.userNameHashCod64;
   }

   public long hashCode64() {
      if (this.hashCode64 == 0L) {
         if (this.host != null) {
            long hash = FnvHash.hashCode64(this.host);
            hash ^= 64L;
            hash *= 1099511628211L;
            hash = FnvHash.hashCode64(hash, this.userName);
            this.hashCode64 = hash;
         } else {
            this.hashCode64 = this.nameHashCode64();
         }
      }

      return this.hashCode64;
   }

   public SQLColumnDefinition getResolvedColumn() {
      return null;
   }
}
