package com.alibaba.druid.sql.dialect.mariadb.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MariadbPrepareStatement extends MariadbStatementImpl {
   private SQLName name;
   private SQLExpr from;

   public MariadbPrepareStatement() {
   }

   public MariadbPrepareStatement(SQLName name, SQLExpr from) {
      this.name = name;
      this.from = from;
   }

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName name) {
      this.name = name;
   }

   public SQLExpr getFrom() {
      return this.from;
   }

   public void setFrom(SQLExpr from) {
      this.from = from;
   }

   public void accept0(MariadbASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.name);
         this.acceptChild(visitor, this.from);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      if (this.name != null) {
         children.add(this.name);
      }

      if (this.from != null) {
         children.add(this.from);
      }

      return children;
   }
}
