package com.alibaba.druid.sql.dialect.mariadb.ast.statement;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLShowCreateTableStatement;
import com.alibaba.druid.sql.dialect.mariadb.ast.MariadbObject;
import com.alibaba.druid.sql.dialect.mariadb.visitor.MariadbASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class MariadbShowCreateTableStatement extends SQLShowCreateTableStatement implements SQLStatement, MariadbObject {
   private SQLExprTableSource table;
   private SQLExpr str;

   public MariadbShowCreateTableStatement() {
      this.dbType = DbType.mysql;
   }

   public void accept0(MariadbASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.table);
      }

      visitor.endVisit(this);
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((MariadbASTVisitor)visitor);
   }

   public SQLExprTableSource getTable() {
      return this.table;
   }

   public void setTable(SQLExprTableSource table) {
      this.table = table;
   }

   public SQLExpr getStr() {
      return this.str;
   }

   public void setStr(SQLExpr str) {
      this.str = str;
   }
}
