package com.alibaba.druid.sql.dialect.mysql.ast.statement;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLSubPartitionBy;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlObject;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MySqlSubPartitionByKey extends SQLSubPartitionBy implements MySqlObject {
   private int algorithm = 2;
   private List<SQLName> columns = new ArrayList();

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof MySqlASTVisitor) {
         this.accept0((MySqlASTVisitor)visitor);
      } else {
         throw new IllegalArgumentException("not support visitor type : " + visitor.getClass().getName());
      }
   }

   public void accept0(MySqlASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.columns);
         this.acceptChild(visitor, this.subPartitionsCount);
      }

      visitor.endVisit(this);
   }

   public List<SQLName> getColumns() {
      return this.columns;
   }

   public void addColumn(SQLName column) {
      if (column != null) {
         column.setParent(this);
      }

      this.columns.add(column);
   }

   public void cloneTo(MySqlSubPartitionByKey x) {
      super.cloneTo(x);

      for(SQLName column : this.columns) {
         SQLName c2 = column.clone();
         c2.setParent(x);
         x.columns.add(c2);
      }

      x.algorithm = this.algorithm;
   }

   public MySqlSubPartitionByKey clone() {
      MySqlSubPartitionByKey x = new MySqlSubPartitionByKey();
      this.cloneTo(x);
      return x;
   }

   public int getAlgorithm() {
      return this.algorithm;
   }

   public void setAlgorithm(int algorithm) {
      this.algorithm = algorithm;
   }

   public boolean isPartitionByColumn(long columnNameHashCode64) {
      for(SQLName column : this.columns) {
         if (column.nameHashCode64() == columnNameHashCode64) {
            return true;
         }
      }

      return false;
   }
}
